package kontrol;

/**
 *
 * @author kagioglu
 */
public class Wheel<G>
{
    private static class Node<G>
    {
        public G value;
        public Node<G> next;
        public Node<G> prev;
    }

    private Node<G> currentSelection;
    private Node<G> insertionPoint;

    public Wheel( G desiredSelection, G[] array )
    {
        this.init();
        for(G g : array)
        {
            this.insert(g, desiredSelection);
        }
    }
    
    private void init()
    {
        this.insertionPoint = new Node<G>();
        this.currentSelection = this.insertionPoint;
        this.insertionPoint.value = null;
        this.insertionPoint.next = this.insertionPoint;
        this.insertionPoint.prev = this.insertionPoint;
    }
    
    private void insert( G g, G desiredSelection )
    {
        Node<G> temp = new Node<G>();
        if(g == desiredSelection) this.currentSelection = temp;
        temp.value = g;
        temp.next = this.insertionPoint;
        temp.prev = this.insertionPoint.prev;
        this.insertionPoint.prev = temp;
        temp.prev.next = temp;
    }

    public void increment()
    {
        this.currentSelection = this.currentSelection.next;
    }

    public void decrement()
    {
        this.currentSelection = this.currentSelection.prev;
    }

    public G getSelection()
    {
        return this.currentSelection.value;
    }
}
