package model;

/**
 * Keeps track of the possible directions one can move in.
 * 
 * @author Adam
 */
public enum Direction {
    N( 0, -1, "N" ),
    S( 0, 1, "S" ),
    E( 1, 0, "E" ),
    W( -1, 0, "W" ),
    NE( 1, -1, "NE" ),
    SW( -1, 1, "SW" ),
    NW( -1, -1, "NW" ),
    SE( 1, 1, "SE" ),
    C( 0, 0, "C" );
    
    public final int x, y;
    public final String dir;
    private static final int[] oppositeMap = new int[]
    {
        1, // N=0 S=1
        0, // S=1 N=0
        3, // E=2 W=3
        2, // W=3 E=2
        5, // NE=4 SW=5
        4, // SW=5 NE=4
        7, // NW=6 SE=7
        6, // SE=7 NW=6
        8
    // C=8 C=8
    };
    
    private Direction( int x, int y, String dir ) {
        this.x = x;
        this.y = y;
        this.dir = dir;
    }
    
    public Direction getOpposite()
    {
        return Direction.values()[ oppositeMap[ this.ordinal() ] ];
    }
}
