package model;

import model.interfaces.selectable.SelectableCommand;
import model.interfaces.commandTypes.ArgumentsVisitor;
import model.interfaces.commandTypes.NoArgs;

/**
 * Command to have army tell its colonists to harvest resources at its current
 * location.
 * 
 * @author Christopher Dudley
 */
class Harvest implements Command, SelectableCommand, NoArgs, NotPartOfTheSystem
{
    
    private static final String name = "Harvest";
    
    /**
     * Accepts an ArgumentsVisitor to correctly determine the arguments type of
     * the command.
     * 
     * @param visitor
     *            the ArgumentsVisitor.
     */
    public void accept( ArgumentsVisitor visitor )
    {
        visitor.visitNoArgs( this );
    }
    
    /**
     * Returns a copy of the harvest command of reference-type Command.
     * 
     * @return a Command-type copy of the command.
     */
    public Command getCommand()
    {
        return this;
    }
    
    /**
     * Returns the name of the command.
     * 
     * @return the name of the command.
     */
    public String getName()
    {
        return name;
    }
    
    /**
     * Executes the command.
     * 
     * @param player
     *            the player that owns the army.
     * @param instance
     *            the instance of the army.
     */
    public void run( Player player, ModelInstance instance )
    {
        player.harvest( instance );
    }
    
    /**
     * It's not part of your system, man!
     */
    public void throwItOnTheGround()
    {
        new ThrowItOnTheGround().cuzMyDadIsNotA( this );
    }
}
