package model;

import model.interfaces.selectable.SelectableCommand;
import model.interfaces.commandTypes.ArgumentsVisitor;

class Heal implements Command, SelectableCommand, NotPartOfTheSystem
{
    public void throwItOnTheGround()
    {
        new ThrowItOnTheGround().cuzMyDadIsNotA( this );
    }
    
    public void run( Player player, ModelInstance instance )
    {
        player.heal( instance );
    }
    
    public void accept( ArgumentsVisitor visitor )
    {
        // do nothing
    }
    
    public String getName()
    {
        return "Heal";
    }
    
    public Command getCommand()
    {
        return this;
    }
}
