package model;

import java.util.EnumMap;
import java.util.Map;

/**
 * This class is called by Move. This class does the effect of the item on a
 * tile based on what the item is.
 * 
 * @author Chris
 * 
 */
class ItemVisitorClass implements ItemVisitor
{
    
    /**
     * @deprecated implemented in Player using isBlocked.
     */
    public void visitObstacle( Obstacle item )
    {
        
    }
    
    /**
     * the player (explorer) stumbles upon an "item" which is a random pile of
     * resources. instantly adds these resources to player without having to
     * harvest them.
     */
    public void visitAddResource( Player p, OneShotAddResource item )
    {
        Map< ResourceType, Integer > temp;
        temp = new EnumMap< ResourceType, Integer >( ResourceType.class );
        temp.put( item.getResourceType(), item.getQuantity() );
        p.addResources( temp );
        
    }
    
    /**
     * heals the unit that walks onto the tile with this item.
     */
    public void visitHeal( OneShotHeal item, ModelInstance mi )
    {
        mi.heal( item.getHealValue() );
    }
    
}
