package model;

import java.awt.Point;
import java.io.Serializable;

/**
 * 
 * @author kagioglu
 */
public class Location implements Comparable< Location >, Serializable
{
    
    private static final long serialVersionUID = 5178807006191306559L;
    public final int x;
    public final int y;
    private final static int MAGICNUMBER_MAPEDGELENGTH = 30;
    
    public Location( int x, int y ) {
        this.x = x;
        this.y = y;
    }
    
    /**
     * Creates a new Location from a Point.
     * 
     * @param point
     *            the point for the new location.
     */
    
    // necessary if this object is being used in a hashmap
    @Override
    public int hashCode()
    {
        return this.x * Location.MAGICNUMBER_MAPEDGELENGTH + this.y;
    }
    
    // thanks netbeans for autogenerating this code for me
    @Override
    public boolean equals( Object obj )
    {
        if ( obj == null ) { return false; }
        if ( getClass() != obj.getClass() ) { return false; }
        final Location other = (Location) obj;
        if ( this.x != other.x ) { return false; }
        if ( this.y != other.y ) { return false; }
        return true;
    }
    
    // necessary if this object is being used in a treemap
    public int compareTo( Location location )
    {
        if ( this.x == location.x )
        {
            return this.y - location.y;
        }
        else
        {
            return this.x - location.x;
        }
    }
    
    /**
     * Returns a Point representation of the location.
     * 
     * @return a point representing the location.
     */
    public Point getPoint()
    {
        return new Point( x, y );
    }
    
    @Override
    public String toString()
    {
        return this.x + " " + this.y;
    }
}
