package model;

import java.util.EnumMap;

/**
 * Interface for view to grab viewable tile information from.
 * 
 * @author Adam
 * 
 */
public interface MagicTile
{
    public EnumMap< InstanceType, Integer > getUnits();
    
    public InstanceType getStructure();
    
    public int[] getRallyPoints();
    
    public TerrainType getTerrain();
    
    public DecalType getDecal();
    
    public ResourceType getResourceType();
    
    public int getResourceCount( ResourceType rt );
    
    public Alliance getAllianceEnum();
    
    // DEVIATION FROM MODEL : lets view see if a tile has an item on it
    public ItemType getItemType();
}
