package model;

import java.util.Map;

public class MagictileTester
{
    public static void main( String[] args )
    {
        Model m = null;
        
        try
        {
            m = new Model( "MapTestFile.map" );
            m.tick();
            
        }
        catch ( Exception e )
        {
            System.out.println( "Ouch, didn't start up properly." );
        }
        
        MagicTile[][] tiles = m.getMagicTiles( 0, 0, 5, 5 );
        
        for ( int i = 0; i < 5; i++ )
        {
            for ( int j = 0; j < 5; j++ )
            {
                System.out.println( "Tile " + i + "," + j );
                switch ( tiles[ i ][ j ].getAllianceEnum() ) {
                    case FRIENDLY:
                        System.out.println( "Friendly" );
                        break;
                    case HOSTILE:
                        System.out.println( "Hostile" );
                        break;
                    default:
                        System.out.println( "Neutral" );
                }
                
                switch ( tiles[ i ][ j ].getDecal() ) {
                    case HEAL_ZONE:
                        System.out.println( "Healing spot" );
                        break;
                    case EXPLORED_BASIC:
                        System.out.println( "Explored" );
                        break;
                    case EXPLORED_FULLY_NO_DECAL:
                        System.out.println( "Explored Fully" );
                        break;
                    case DANGER_ZONE:
                        System.out.println( "Danger Zone" );
                        break;
                    default:
                        System.out.println( "Unexplored" );
                }
                
                switch ( tiles[ i ][ j ].getResourceType() ) {
                    case BLUE:
                        System.out.print( "Blue resources: " );
                        break;
                    case GREEN:
                        System.out.print( "Green resources: " );
                        break;
                    case RED:
                        System.out.print( "Red resources: " );
                        break;
                    default:
                        System.out.print( "No resources: " );
                }
                
                System.out.println( tiles[ i ][ j ].getResourceCount( tiles[ i ][ j ].getResourceType() ) );
                
                switch ( tiles[ i ][ j ].getTerrain() ) {
                    case ARID_DESERT:
                        System.out.println( "Arid desert" );
                        break;
                    case DANK_FOREST:
                        System.out.println( "Dank Forest" );
                        break;
                    case GRASSLAND:
                        System.out.println( "Grassland" );
                        break;
                    case OUTER_SPACE:
                        System.out.println( "Outer space" );
                        break;
                    case HOSPITAL:
                        System.out.println( "Hospital" );
                        break;
                    case PARAGUAY:
                        System.out.println( "Paraguay" );
                        break;
                    case THE_MATRIX:
                        System.out.println( "The Matrix" );
                        break;
                    default:
                        System.out.println( "Unknown terrain" );
                }
                
                Map< InstanceType, Integer > units = tiles[ i ][ j ].getUnits();
                Integer n = units.get( InstanceType.COLONIST );
                if ( n != null )
                    System.out.print( n.toString() );
                else
                    System.out.print( "0" );
                System.out.println( " colonist(s)" );
                
                n = units.get( InstanceType.EXPLORER );
                if ( n != null )
                    System.out.print( n.toString() );
                else
                    System.out.print( "0" );
                System.out.println( " explorer(s)" );
                
                n = units.get( InstanceType.MELEE );
                if ( n != null )
                    System.out.print( n.toString() );
                else
                    System.out.print( "0" );
                System.out.println( " melee(s)" );
                
                n = units.get( InstanceType.RANGED );
                if ( n != null )
                    System.out.print( n.toString() );
                else
                    System.out.print( "0" );
                System.out.println( " ranged(s)" );
                
                switch ( tiles[ i ][ j ].getStructure() ) {
                    case TOWER:
                        System.out.println( "Tower" );
                        break;
                    case BASE:
                        System.out.println( "Base" );
                        break;
                    default:
                        System.out.println( "No structure" );
                }
                
                System.out.println();
            }
        }
    }
}
