package model;

import java.io.*;
import java.util.Random;

/**
 * A class to build a fully working map.
 * 
 * @author Adam
 * 
 */

public class MapMaker
{
    public static void main( String[] args )
    {
        GameMap map = new GameMap( 30, 30 );
        
        Random rnd = new Random();
        
        for ( int i = 0; i < 30; i++ )
        {
            for ( int j = 0; j < 30; j++ )
            {
                if ( (i == 1 && j == 1) && (i == 28 && j == 28) )
                {
                    map.setTile( i, j, new Tile( TerrainType.GRASSLAND, ResourceType.NONE, 0, null ) );
                }
                else
                {
                    TerrainType tt = TerrainType.UNKNOWN;
                    
                    switch ( rnd.nextInt( 15 ) ) {
                        case 0:
                            tt = TerrainType.OUTER_SPACE;
                            break;
                        case 1:
                            tt = TerrainType.ARID_DESERT;
                            break;
                        case 2:
                            tt = TerrainType.DANK_FOREST;
                            break;
                        case 3:
                            tt = TerrainType.PLATEAU;
                            break;
                        case 4:
                            tt = TerrainType.HOSPITAL;
                            break;
                        case 5:
                            tt = TerrainType.PARAGUAY;
                            break;
                        case 6:
                            tt = TerrainType.THE_MATRIX;
                            break;
                        default:
                            tt = TerrainType.GRASSLAND;
                    }
                    
                    ResourceType rt = ResourceType.NONE;
                    int count = 0;
                    
                    switch ( rnd.nextInt( 5 ) ) {
                        case 0:
                            rt = ResourceType.RED;
                            count = rnd.nextInt( 10 ) * 5;
                            break;
                        case 1:
                            rt = ResourceType.BLUE;
                            count = rnd.nextInt( 10 ) * 5;
                            break;
                        case 2:
                            rt = ResourceType.GREEN;
                            count = rnd.nextInt( 10 ) * 5;
                            break;
                        default:
                    }
                    
                    Item item;
                    
                    switch ( rnd.nextInt( 10 ) ) {
                        case 0:
                            item = new Obstacle();
                            break;
                        case 1:
                        case 2:
                        case 3:
                            item = new OneShotHeal();
                            break;
                        case 4:
                            item = new OneShotAddResource( ItemType.CLOAK_OF_SERENITY,
                                    ResourceType.GREEN, 50 );
                            break;
                        case 5:
                            item = new OneShotAddResource( ItemType.ROD_OF_SORROW,
                                    ResourceType.BLUE, 50 );
                            break;
                        case 6:
                            item = new OneShotAddResource( ItemType.SCABBARD_OF_WARMTH,
                                    ResourceType.RED, 50 );
                            break;
                        default:
                            item = null;
                    }
                    
                    map.setTile( i, j, new Tile( tt, rt, count, item ) );
                }
            }
        }
        
        map.setStartingLocation1( new Location( 1, 1 ) );
        map.setStartingLocation2( new Location( 28, 28 ) );
        
        try
        {
            FileOutputStream w = new FileOutputStream( "MapTestFile.map" );
            ObjectOutputStream writer = new ObjectOutputStream( w );
            writer.writeObject( map );
            System.out.println( "SUCCESSFUL BUILD" );
        }
        catch ( FileNotFoundException e )
        {
            e.printStackTrace();
            System.out.println( "ERROR: File not found" );
        }
        catch ( IOException e )
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
            System.out.println( "ERROR: IO Exception" );
        }
        
    }
}
