package model;

import java.util.Iterator;
import java.util.List;
import java.util.EnumMap;
import java.util.Map;

/**
 * 
 * @author ryan
 */

public class PlayerTest
{
    
    public static void main( String[] args )
    {
        GameMap testMap = new GameMap( 15, 15 );
        Map< ResourceType, Integer > testResources = new EnumMap< ResourceType, Integer >(
                ResourceType.class );
        
        testResources.put( ResourceType.BLUE, 1000 );
        testResources.put( ResourceType.RED, 1000 );
        testResources.put( ResourceType.GREEN, 1000 );
        
        Player testPlayer = new Human( testMap, new Location( 0, 0 ), testResources );
        
        System.out.println( testPlayer.toString() );
        
        List< Unit > units = testPlayer.getUnitsAt( new Location( 0, 0 ) );
        
        for ( Iterator< Unit > it = units.iterator(); it.hasNext(); )
        {
            Unit u = (Unit) it.next();
            System.out.println( u.getName() );
        }
        
        System.out.println();
        System.out.println( testPlayer.toString() );
        System.out.println( "Units after build:" );
        
        testPlayer.buildBase( units.get( 2 ) );
        testPlayer.trainMelee( testPlayer.getStructureAt( new Location( 0, 0 ) ) );
        testPlayer.trainRanged( testPlayer.getStructureAt( new Location( 0, 0 ) ) );
        testPlayer.trainMelee( testPlayer.getStructureAt( new Location( 0, 0 ) ) );
        testPlayer.trainMelee( testPlayer.getStructureAt( new Location( 0, 0 ) ) );
        
        units = testPlayer.getUnitsAt( new Location( 0, 0 ) );
        
        for ( Iterator< Unit > it = units.iterator(); it.hasNext(); )
        {
            Unit u = (Unit) it.next();
            System.out.println( u.getName() );
        }
        
    }
    
}
