package model;

import model.interfaces.selectable.SelectableCommand;
import model.interfaces.commandTypes.ArgumentsVisitor;

class PowerDown implements Command, SelectableCommand, NotPartOfTheSystem
{
    public void throwItOnTheGround()
    {
        new ThrowItOnTheGround().cuzMyDadIsNotA( this );
    }
    
    public void run( Player player, ModelInstance instance )
    {
        instance.powerDown();
    }
    
    public void accept( ArgumentsVisitor visitor )
    {
        // do nothing
    }
    
    public String getName()
    {
        return "PowerDown";
    }
    
    public Command getCommand()
    {
        return this;
    }
}
