package model;

import _bye_util.IntRecycler;

import model.interfaces.selectable.SelectableCommand;

import java.util.List;
import java.util.ArrayList;

/**
 * 
 * @author Chris
 * 
 */
class Ranged extends Unit
{
    Ranged( IntRecycler i ) {
        super( i, // int recycler
               InstanceType.RANGED, // instance type
               10, // armor
               20, // attack power
               5, // defense power
               3, // speed
               "Ranged", // name
               5, // upkeep red
               0, // upkeep green
               0 // upkeep blue
        );
    }
    
    /**
     * Ranged units are jerks and don't have any additional commands for a rally
     * point.
     * 
     * @return the additional commands this unit brings to a rally point (null).
     */
    public List< SelectableCommand > getAdditionalCommands()
    {
        return new ArrayList< SelectableCommand >();
    }
}
