package model;

import java.io.Serializable;

class Tile implements Serializable
{
    /**
	 * 
	 */
    private static final long serialVersionUID = 5757845603319008509L;
    private Item item = null;
    private ResourceType resource = ResourceType.NONE;
    private int resourceCount = 0;
    private TerrainType terrainType = TerrainType.UNKNOWN;
    
    public Tile( TerrainType t, ResourceType r, int rCount, Item i ) {
        terrainType = t;
        resource = r;
        resourceCount = rCount;
        item = i;
    }
    
    public boolean hasItem()
    {
        return item != null;
    }
    
    public Item getItem()
    {
        return item;
    }
    
    public void removeItem()
    {
        item = null;
    }
    
    public boolean hasResource()
    {
        return resource != ResourceType.NONE;
    }
    
    public ResourceType getResource()
    {
        return resource;
    }
    
    public int getResourceCount()
    {
        return resourceCount;
    }
    
    public void subtractResource( int toll )
    {
        resourceCount -= toll;
        if ( resourceCount <= 0 ) this.resource = ResourceType.NONE;
        resourceCount = 0;
    }
    
    public TerrainType getTerrainType()
    {
        return terrainType;
    }
}
