package model;

import model.interfaces.commandTypes.ArgumentsVisitor;
import model.interfaces.commandTypes.NoArgs;
import model.interfaces.selectable.SelectableCommand;

/**
 * Command that trains a new Melee unit.
 * 
 * @author Alex Kagioglu
 * @author Christopher Dudley
 */
class TrainMelee implements Command, SelectableCommand, NoArgs, NotPartOfTheSystem
{
    private static final String name = "Train Melee";
    
    /**
     * Accepts an ArgumentsVisitor to correctly determine the arguments type and
     * queue the command.
     * 
     * @param visitor
     *            the ArgumentsVisitor.
     */
    public void accept( ArgumentsVisitor visitor )
    {
        visitor.visitNoArgs( this );
    }
    
    /**
     * Returns a Command version of itself that can be executed.
     * 
     * @return a command interface version of this command.
     */
    public Command getCommand()
    {
        return this;
    }
    
    /**
     * Returns the name of the command.
     * 
     * @return the name of the command.
     */
    public String getName()
    {
        return name;
    }
    
    /**
     * Executes the command.
     * 
     * @param player
     *            the player that owns the base creating a new Melee.
     * @param instance
     *            the base that is creating the new Melee.
     */
    public void run( Player player, ModelInstance instance )
    {
        player.trainMelee( instance );
    }
    
    /**
     * It's not part of your system, man!
     */
    public void throwItOnTheGround()
    {
        new ThrowItOnTheGround().cuzMyDadIsNotA( this );
    }
}
