package model;

import model.interfaces.selectable.SelectableType;
import model.interfaces.selectable.SelectableInstance;

import java.util.List;
import java.util.ArrayList;

/**
 * Represents a type of selectable objects in a group. Contains a list of the
 * various instances of this type.
 * 
 * @author Chrisotpher Dudley
 * @author Alex Kagioglu
 */
public class Type implements SelectableType, NotPartOfTheSystem
{
    private String name;
    private List< SelectableInstance > instList;
    
    /**
     * Creates a new Type with the specified name and an empty list of
     * SelectableInstances.
     * 
     * @author Christopher Dudley
     * 
     * @param name
     *            the name of the type.
     */
    public Type( String name ) {
        instList = new ArrayList< SelectableInstance >();
        this.name = name;
    }
    
    /**
     * I'm not part of your system!
     * 
     * @author Alex Kagioglu
     */
    public void throwItOnTheGround()
    {
        new ThrowItOnTheGround().cuzMyDadIsNotA( this );
    }
    
    /**
     * Returns the list of selectable instances of this type.
     * 
     * @author Christopher Dudley
     * 
     * @return
     */
    public SelectableInstance[] getInstances()
    {
        SelectableInstance[] siArray = new SelectableInstance[ instList.size() ];
        siArray = instList.toArray( siArray );
        return siArray;
    }
    
    /**
     * Returns the name of the type.
     * 
     * @author Alex Kagioglu
     * 
     * @return the name of the type.
     */
    public String getName()
    {
        return name;
    }
    
    // Deviation: Removed setName()
    // Not required with the name set in the constructor.
    
    /**
     * Adds a new SelectableInstance to this type.
     * 
     * @param instance
     *            the SelectableInstance to add to the type.
     */
    public void addSelectableInstance( SelectableInstance instance )
    {
        instList.add( instance );
    }
    
    /**
     * Removes a specified SelectableInstance from this type.
     * 
     * @param instance
     *            the instance to remove from the type.
     */
    public void removeSelectableInstance( SelectableInstance instance )
    {
        instList.remove( instance );
    }
}
