/*
 * File: MoveArgs.java
 */

package model.interfaces.commandTypes;

import model.Direction;

/**
 * Implemented by commands that move a unit and therefore require a list of
 * directions.
 * 
 * @author Christopher Dudley
 */
public interface MoveArgs
{
    
    /**
     * Sets the list of directions required for the move command.
     * 
     * @param directions
     *            the list of directions (of the enumerated direction type) for
     *            the unit to move.
     */
    public void setArgs( Direction[] directions );
}
