/*
 * File: SelectableCommand.java
 */

package model.interfaces.selectable;

import model.interfaces.commandTypes.ArgumentsVisitor;
import model.Command;

/**
 * Allows controllers to query for information about a selectable command, as
 * well as issue that command to an instance.
 * 
 * @author Christopher Dudley
 */
public interface SelectableCommand
{
    
    /**
     * Calls the correct method in the visitor to manage the command based on
     * what type of arguments it requires, if any.
     * 
     * @param av
     *            the visitor.
     */
    public void accept( ArgumentsVisitor av );
    
    /**
     * Returns the name of the command as a String.
     * 
     * @return The command's name.
     */
    public String getName();
    
    /**
     * Gets the Command reference type of the command.
     * 
     * @return Command reference to the command.
     */
    public Command getCommand();
}
