/*
 * File: SelectableInstance.java
 */

package model.interfaces.selectable;

/**
 * Allows the controllers to query for information about an instance of
 * something selectable in the game and the different commands that can be
 * issued to it.
 * 
 * @author Christopher Dudley
 */
public interface SelectableInstance
{
    
    /**
     * Adds the given command to the instance's queue.
     * 
     * @param command
     *            the command to issue to the instance.
     */
    public void addCommandToQueue( SelectableCommand command );
    
    /**
     * Cancels any current orders that the instance may currently have in its
     * queue.
     */
    public void cancelPendingOrders();
    
    /**
     * Returns a list of the commands that can be issued to this instance at
     * this point in time.
     * 
     * @return a list of issuable commands.
     */
    public SelectableCommand[] getCommands();
    
    /*
     * Deviation: added getID() Need this to use hotkeys to select a unit when
     * in a menu.
     */
    /**
     * Returns the ID number of the instance.
     * 
     * @return the instance's ID number.
     */
    public int getID();
    
    /**
     * Returns the name of the instance as a String.
     * 
     * @return the name of the instance.
     */
    public String getName();
    
    /**
     * Returns the type of the unit and its health through an object that
     * implements the InstanceTypeAndHealth interface.
     * 
     * @return the type and health of the instance.
     */
    public InstanceTypeAndHealth[] getStatus();
}
