/*
 * File: SelectableStructure.java
 */

package model.interfaces.selectable;

/**
 * Allows controller and view access to information about a selectable
 * structure's name and current queue.
 * 
 * @author Christopher Dudley
 */
public interface SelectableStructure
{
    
    /**
     * Returns the name of the structure as a string.
     * 
     * @return
     */
    public String getName();
    
    /**
     * Returns a list of the commands currently in the structure's queue.
     * 
     * @return commands in the structure's queue.
     */
    public SelectableCommand[] getQueue();
    
    public int getID();
}
