/*
 * File: SelectableType.java
 */

package model.interfaces.selectable;

/**
 * Allows the controllers to query for information about a type of selectable
 * thing that a player owns and the list of instances of the type.
 * 
 * @author Christopher Dudley
 */
public interface SelectableType
{
    
    /**
     * Returns the type's name as a String.
     * 
     * @return the name of the type.
     */
    public String getName();
    
    /**
     * Returns a list of the selectable instances of this type.
     * 
     * @return a list of selectable instances of this type.
     */
    public SelectableInstance[] getInstances();
}
