/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package view;

import java.awt.image.BufferedImage;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import javax.imageio.ImageIO;
import java.io.File;
import java.awt.Font;

/**
 * 
 * @author spock
 */
class CommandQueueOverview
{
    final private static int CQOWIDTH = 240;
    final private static int CQOHEIGHT = 225;
    
    private BufferedImage imageBuffer;
    private String title;
    private String[] list;
    private Graphics2D graphix;
    private Image sandy;
    
    // constructor
    CommandQueueOverview() {
        title = "Command Queue";
        list = new String[]
        {
            "command 1", "command 2", "command 3", "command 4", "command 5", "command 6"
        };
        try
        {
            sandy = ImageIO.read( new File( "view/sand.png" ) );
        }
        catch ( Exception c )
        {
            System.out.println( "exception" );
        }
    }
    
    // sets the new set of command queue and refresh
    void setCommands( String[] list )
    {
        this.list = list;
        refreshImage();
    }
    
    // clears the command queue
    void clearCommandQueue()
    {
        this.list = new String[] {};
        refreshImage();
    }
    
    // refreshes the image of the command queue
    void refreshImage()
    {
        imageBuffer = new BufferedImage( CQOWIDTH, CQOHEIGHT, BufferedImage.TYPE_INT_ARGB );
        graphix = imageBuffer.createGraphics();
        
        graphix.setRenderingHint( RenderingHints.KEY_ANTIALIASING,
                                  RenderingHints.VALUE_ANTIALIAS_ON );
        
        graphix.setStroke( new BasicStroke( 5.0f ) );
        graphix.setColor( Color.BLACK );
        graphix.drawImage( sandy, 0, 0, null );
        
        Font f1 = new Font( "Times Roman", Font.BOLD, 14 );
        graphix.setFont( f1 );
        graphix.drawString( title, 20, 35 );
        f1 = new Font( "Times Roman", Font.BOLD, 12 );
        graphix.setFont( f1 );
        for ( int i = 0; i < list.length && i < 5; ++i )
        {
            graphix.drawString( (i + 1) + ". " + list[ i ], 20, 60 + 30 * i );
        }
        
        if ( list.length > 4 )
        {
            graphix.drawString( "...", 20, 60 + 30 * 5 );
        }
        
        graphix.setColor( Color.ORANGE );
        graphix.drawRect( 0, 0, CQOWIDTH, CQOHEIGHT );
        
    }
    
    // returns current image
    BufferedImage getImage()
    {
        return imageBuffer;
    }
    
}
