/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package view;

import java.awt.Color;
import java.awt.image.BufferedImage;
import model.interfaces.selectable.InstanceTypeAndHealth;
import java.awt.Graphics2D;
import java.awt.Font;
import java.awt.BasicStroke;
import java.awt.RenderingHints;
import java.awt.Image;
import java.io.File;
import javax.imageio.ImageIO;
import model.InstanceType;

/**
 * 
 * @author spock
 */
class HUD
{
    private GraphicsTable graphics; // contains the graphics for HUD
    private BufferedImage imageBuffer; // contains the image of HUD
    private String groupBox; // contains info for the groupBox
    private String typeBox; // contains info for the typeBox
    private String instanceBox; // contains info for the instanceBox
    private String commandBox; // contains info for the commandBox
    private int[] resources; // contains info for the resources
    private InstanceTypeAndHealth[] statusOverview; // containes info for SO
    private final static int HUDWIDTH = 800; // width
    private final static int HUDHEIGHT = 150; // height
    private Graphics2D graphix; // graphics object
    private Image scroll; // image as are the rest to follow
    private Image rgb;
    private Image dark;
    private Image ceilingCat;
    private Image duneCat;
    private Image monorailCat;
    private Image tiger;
    private Image pandaBear;
    private Image polarBear;
    
    // constructor
    HUD() {
        try
        {
            scroll = ImageIO.read( new File( "view/scroll.png" ) );
            rgb = ImageIO.read( new File( "view/rgb.png" ) );
            dark = ImageIO.read( new File( "view/dark.png" ) );
            ceilingCat = ImageIO.read( new File( "view/explore.jpg" ) );
            duneCat = ImageIO.read( new File( "view/wrench.jpg" ) );
            monorailCat = ImageIO.read( new File( "view/ranged2.jpg" ) );
            tiger = ImageIO.read( new File( "view/sword.jpg" ) );
            pandaBear = ImageIO.read( new File( "view/castle.jpg" ) );
            polarBear = ImageIO.read( new File( "view/tower.jpg" ) );
        }
        catch ( Exception c )
        {
            System.out.println( "exception" );
        }
        
        InstanceType[] enums = new InstanceType[ 7 ];
        int i = 0;
        for ( InstanceType instanceType : InstanceType.values() )
        {
            enums[ i ] = instanceType;
            ++i;
        }
        graphics = new GraphicsTable( enums, new Image[]
        {
            tiger, monorailCat, duneCat, ceilingCat, pandaBear, polarBear, null
        } );
        
        groupBox = "Welcome";
        typeBox = "To";
        instanceBox = "Our";
        commandBox = "Game";
        resources = new int[ 3 ];
        resources[ 0 ] = 0;
        resources[ 1 ] = 0;
        resources[ 2 ] = 0;
    }
    
    // refreshes the HUD
    void refreshImage()
    {
        
        imageBuffer = new BufferedImage( HUDWIDTH, HUDHEIGHT, BufferedImage.TYPE_INT_ARGB );
        graphix = imageBuffer.createGraphics();
        
        graphix.setRenderingHint( RenderingHints.KEY_ANTIALIASING,
                                  RenderingHints.VALUE_ANTIALIAS_ON );
        
        graphix.setStroke( new BasicStroke( 5.0f ) );
        graphix.setColor( Color.BLACK );
        graphix.drawImage( rgb, 0, 2, null );
        graphix.drawImage( scroll, (int) ((.25) * HUDWIDTH + 5.0), 2, null );
        graphix.drawImage( scroll, (int) ((.4375) * HUDWIDTH + 5.0), 2, null );
        graphix.drawImage( scroll, (int) ((.625) * HUDWIDTH + 5.0), 2, null );
        graphix.drawImage( scroll, (int) ((.8125) * HUDWIDTH + 5.0), 2, null );
        graphix.drawImage( dark, 0, (HUDHEIGHT / 3), null );
        
        graphix.drawLine( 0, 0, HUDWIDTH, 0 );
        graphix.drawLine( 0, (HUDHEIGHT / 3), HUDWIDTH, (HUDHEIGHT / 3) );
        graphix.drawLine( (int) ((.25) * HUDWIDTH + 5.0), 0, (int) ((.25) * HUDWIDTH + 5.0),
                          (HUDHEIGHT / 3) );
        graphix.drawLine( (int) ((.4375) * HUDWIDTH + 5.0), 0, (int) ((.4375) * HUDWIDTH + 5.0),
                          (HUDHEIGHT / 3) );
        graphix.drawLine( (int) ((.625) * HUDWIDTH + 5.0), 0, (int) ((.625) * HUDWIDTH + 5.0),
                          (HUDHEIGHT / 3) );
        graphix.drawLine( (int) ((.8125) * HUDWIDTH + 5.0), 0, (int) ((.8125) * HUDWIDTH + 5.0),
                          (HUDHEIGHT / 3) );
        Font f1 = new Font( "Times Roman", Font.BOLD, 15 );
        graphix.setFont( f1 );
        graphix.setColor( Color.WHITE );
        graphix.drawString( "" + resources[ 0 ], (float) ((0) * HUDWIDTH + 20.0),
                            (float) ((.200) * HUDHEIGHT) );
        graphix.drawString( "" + resources[ 1 ], (float) ((.083333) * HUDWIDTH + 20.0),
                            (float) ((.200) * HUDHEIGHT) );
        graphix.drawString( "" + resources[ 2 ], (float) ((.16666) * HUDWIDTH + 20.0),
                            (float) ((.200) * HUDHEIGHT) );
        graphix.setColor( Color.BLACK );
        graphix.drawString( groupBox, (float) ((.25) * HUDWIDTH + 20.0),
                            (float) ((.200) * HUDHEIGHT) );
        graphix.drawString( typeBox, (float) ((.4375) * HUDWIDTH + 20.0),
                            (float) ((.200) * HUDHEIGHT) );
        graphix.drawString( instanceBox, (float) ((.625) * HUDWIDTH + 20.0),
                            (float) ((.200) * HUDHEIGHT) );
        graphix.drawString( commandBox, (float) ((.8125) * HUDWIDTH + 20.0),
                            (float) ((.200) * HUDHEIGHT) );
        
        for ( int i = 0; statusOverview != null && i < statusOverview.length; ++i )
        {
            if ( i < 13 )
            {
                graphix.drawImage( graphics.getGraphic( statusOverview[ i ].getType() ),
                                   10 + 61 * i, 5 + 50, null );
                graphix.setColor( Color.GREEN );
                graphix.fillRect( 10 + 61 * i, 35 + 50,
                                  (int) (((double) (statusOverview[ i ].getPercentHealth())) * .4),
                                  10 );
            }
            else
            {
                graphix.drawImage( graphics.getGraphic( statusOverview[ i ].getType() ),
                                   10 + 61 * (i - 13), 55 + 50, null );
                graphix.setColor( Color.GREEN );
                graphix.fillRect( 10 + 61 * (i - 13), 85 + 50,
                                  (int) (((double) (statusOverview[ i ].getPercentHealth())) * .4),
                                  10 );
            }
        }
        
    }
    
    // sets the current status overview window and refreshes
    void setSelectionOverview( InstanceTypeAndHealth[] instances )
    {
        statusOverview = instances;
        refreshImage();
    }
    
    // sets the group box
    void setGroupBox( String groupBox )
    {
        this.groupBox = groupBox;
        refreshImage();
    }
    
    // sets the type box
    void setTypeBox( String typeBox )
    {
        this.typeBox = typeBox;
        refreshImage();
    }
    
    // sets the instance box
    void setInstanceBox( String instanceBox )
    {
        this.instanceBox = instanceBox;
        refreshImage();
    }
    
    // sets the command box
    void setCommandBox( String commandBox )
    {
        this.commandBox = commandBox;
        refreshImage();
    }
    
    // sets the resources
    void setResources( int[] resources )
    {
        this.resources = resources;
        refreshImage();
    }
    
    // returnss the image of the HUD
    BufferedImage getImage()
    {
        return imageBuffer;
    }
}
