/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package view;

import java.awt.image.BufferedImage;
import java.awt.Image;
import javax.imageio.ImageIO;
import java.io.File;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;

/**
 * 
 * @author spock
 */
//
class Overview
{
    final private static int OVERWIDTH = 300; // width
    final private static int OVERHEIGHT = 420; // height
    private BufferedImage selectionBuffer; // image to be transarent and show
                                           // selection
    private BufferedImage imageBuffer; // contains the image of the Overview;
    private GraphicsTable graphics; // contains the graphics translations
    private String[] list; // contains the list of instances pertaining to
                           // Overview
    private String title; // contains title of the Overview
    private int indexSelection; // index of selection
    private Image background; // image
    private Graphics2D graphix; // graphics object to draw
    private String[] legend; // legend for overview
    
    // Constructor for the Overview
    Overview() {
        list = new String[]
        {
            "hi", "I'm an Army", "We are armies", "oh no", "a", "oh snap!", "crack", "pop",
            "whatchu", "want"
        };
        title = "TestTitle";
        indexSelection = 3;
        legend = new String[]
        {
            "hi", "I just lost the game"
        };
        try
        {
            background = ImageIO.read( new File( "view/sand.png" ) );
        }
        catch ( Exception c )
        {
            System.out.println( "exception" );
        }
        
    }
    
    // opens the overview with initial values
    void setOpen( String title, String[] list, String[] legend )
    {
        this.title = title;
        this.list = list;
        this.legend = legend;
        refreshImage();
    }
    
    // sets the list of teh current overview
    void setList( String[] list )
    {
        this.list = list;
        refreshImage();
    }
    
    // sets the current selection index
    void setIndexSelection( int indexSelection )
    {
        this.indexSelection = indexSelection;
        refreshImage();
    }
    
    // refreshes the image of the Overview
    void refreshImage()
    {
        imageBuffer = new BufferedImage( OVERWIDTH, OVERHEIGHT, BufferedImage.TYPE_INT_ARGB );
        graphix = imageBuffer.createGraphics();
        
        graphix.setRenderingHint( RenderingHints.KEY_ANTIALIASING,
                                  RenderingHints.VALUE_ANTIALIAS_ON );
        
        // background image
        graphix.setStroke( new BasicStroke( 2.5f ) );
        graphix.drawImage( background, 0, 0, null );
        
        // selection highlighting
        if ( indexSelection >= 0 && indexSelection < list.length )
        {
            selectionBuffer = new BufferedImage( OVERWIDTH, 20, BufferedImage.TYPE_INT_ARGB );
            Graphics2D graphiz = selectionBuffer.createGraphics();
            graphiz.setColor( new Color( 255, 255, 0, 120 ) );
            graphiz.fillRect( 0, 0, OVERWIDTH, 20 );
            graphix.drawImage( selectionBuffer, 0, 50 + 25 * indexSelection, null );
        }
        // list itself
        graphix.setColor( Color.BLACK );
        Font f1 = new Font( "Times Roman", Font.BOLD, 16 );
        graphix.setFont( f1 );
        graphix.drawString( title, 20, 35 );
        f1 = new Font( "Times Roman", Font.BOLD, 13 );
        graphix.setFont( f1 );
        for ( int i = 0; i < list.length; ++i )
        {
            graphix.drawString( list[ i ], 20, 65 + 25 * i );
        }
        graphix.setColor( Color.DARK_GRAY );
        graphix.drawString( "LEGEND:", 20, 65 + 25 * 10 );
        for ( int i = 0; legend != null && i < legend.length; ++i )
        {
            graphix.drawString( legend[ i ], 20, 346 + i * 16 );
        }
        
        graphix.setColor( Color.ORANGE );
        graphix.drawRect( 0, 0, OVERWIDTH, OVERHEIGHT );
    }
    
    // returns the image of the Overview
    BufferedImage getImage()
    {
        return imageBuffer;
    }
    
}
