/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package view;

import java.awt.BorderLayout;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;

import javax.swing.JApplet;
import javax.swing.JFrame;

import model.GameListener;
import model.TileTranslator;
import model.interfaces.selectable.InstanceTypeAndHealth;
import control.Control;
import model.ResourceType;

/**
 * 
 * @author spock
 */
public class View implements ViewOverview, ViewHUD, ViewViewPort, Vew, GameListener
{
    
    Graphics2D graphix;
    
    private static ScreenManager screenManager;
    
    private static KeyListener listen;
    
    private static int MWIDTH;
    private static int MHEIGHT;
    
    private int x = 1;
    private int y = 1;
    
    BufferedImage imageBuffer; // image for the View
    ScreenManager screen; // image that the view uses to create the screen
    private static TileTranslator tileFetch; // so that the view knows who to
                                             // query for what
    
    public static void createAndShowGUI()
    {
        
        JApplet applet = new ScreenManager();
        screenManager = (ScreenManager) applet;
        applet.init();
        JFrame frame = ((ScreenManager) applet).getFrame();
        frame.getContentPane().add( applet, BorderLayout.CENTER );
        frame.addKeyListener( listen );
        frame.pack();
        frame.setVisible( true );
    }
    
    // highlights the tiles on the path
    public void setSelectedPath( Point[] path )
    {
        if ( path != null && path.length > 0 )
        {
            int tempX = (int) (path[ path.length - 1 ].getX());
            int tempY = (int) (path[ path.length - 1 ].getY());
            if ( tempX < 2 )
            {
                tempX = 2;
                if ( tempY < 1 )
                {
                    tempY = 1;
                }
                else if ( tempY > MHEIGHT - 2 )
                {
                    tempY = MHEIGHT - 2;
                }
            }
            else if ( tempX > MWIDTH - 3 )
            {
                tempX = MWIDTH - 3;
                if ( tempY < 1 )
                {
                    tempY = 1;
                }
                else if ( tempY > MHEIGHT - 2 )
                {
                    tempY = MHEIGHT - 2;
                }
            }
            else if ( tempY < 1 )
            {
                tempY = 1;
            }
            else if ( tempY > MHEIGHT - 2 )
            {
                tempY = MHEIGHT - 2;
            }
            ((screenManager.getMainScreen()).getViewPort()).setPath( path, x - 2, y - 1 );
            center( new Point( tempX, tempY ) );
        }
        else
        {
            ((screenManager.getMainScreen()).getViewPort()).setPath( path, x - 2, y - 1 );
        }
    }
    
    // moves viewPort to the selected unit
    public void center( Point p )
    {
        x = (int) p.getX();
        y = (int) p.getY();
        if ( x < 2 )
        {
            x = 2;
            if ( y < 1 )
            {
                y = 1;
            }
            else if ( y > MHEIGHT - 2 )
            {
                y = MHEIGHT - 2;
            }
        }
        else if ( x > MWIDTH - 3 )
        {
            x = MWIDTH - 3;
            if ( y < 1 )
            {
                y = 1;
            }
            else if ( y > MHEIGHT - 2 )
            {
                y = MHEIGHT - 2;
            }
        }
        else if ( y < 1 )
        {
            y = 1;
        }
        else if ( y > MHEIGHT - 2 )
        {
            y = MHEIGHT - 2;
        }
        ((screenManager.getMainScreen()).getViewPort()).setTiles( tileFetch.getMagicTiles( x - 2,
                                                                                           y - 1,
                                                                                           5, 3 ) );
        ((screenManager.getMainScreen()).getViewPort()).refreshImage();
        screenManager.refreshMe();
    }
    
    // registers a keylistener with the view
    public void addKeyListener( KeyListener listener )
    {
        // frame.addKeyListener( listener );
    }
    
    // removes a keylistener from the view
    public void removeKeyListener( KeyListener listener )
    {
        // frame.removeKeyListener( listener );
    }
    
    // registers a Model with the view
    public void register( TileTranslator trainTracks, Control control )
    {
        tileFetch = trainTracks;
        MWIDTH = tileFetch.getMapWidth();
        MHEIGHT = tileFetch.getMapHeight();
        x = 2;
        y = 1;
        // ((screenManager.getMainScreen()).getViewPort()).setTiles(tileFetch.getMagicTiles(0,
        // 0, 5, 3));
        // screenManager.refreshMe();
        listen = control;
    }
    
    public static void initMap()
    {
        ((screenManager.getMainScreen()).getViewPort()).setTiles( tileFetch.getMagicTiles( 0, 0, 5,
                                                                                           3 ) );
        screenManager.refreshMe();
    }
    
    // opens the overview
    public void openOverview( String name, String[] instances, String[] legend )
    {
        (screenManager.getOverview()).setOpen( name, instances, legend );
        screenManager.showOverview();
        screenManager.refreshMe();
    }
    
    // sets the Overview
    public void setOverview( String[] instances )
    {
        (screenManager.getOverview()).setList( instances );
        screenManager.refreshMe();
    }
    
    // sets the selection index in the Overview
    public void setSelectionIndex( int index )
    {
        (screenManager.getOverview()).setIndexSelection( index );
        screenManager.refreshMe();
    }
    
    // closes the current Overview
    public void closeOverview()
    {
        screenManager.hideOverview();
        screenManager.refreshMe();
    }
    
    // opens the command queue of the currently selected instance
    public void openCommandQueue( String[] commands )
    {
        screenManager.showCommandQueueOverview( commands );
        screenManager.refreshMe();
    }
    
    // sets the current command queue
    public void setCommandQueue( String[] commands )
    {
        (screenManager.getCommandQueueOverview()).setCommands( commands );
        screenManager.refreshMe();
    }
    
    // closes the current command queue
    public void closeCommandQueue()
    {
        screenManager.hideCommandQueueOverview();
        screenManager.refreshMe();
    }
    
    // sets the groupBox's text
    public void setGroupBox( String text )
    {
        (screenManager.getMainScreen()).getHUD().setGroupBox( text );
        (screenManager.getMainScreen()).refreshImage();
        screenManager.refreshMe();
    }
    
    // sets the typeBox's text
    public void setTypeBox( String text )
    {
        (screenManager.getMainScreen()).getHUD().setTypeBox( text );
        (screenManager.getMainScreen()).refreshImage();
        screenManager.refreshMe();
    }
    
    // sets the instanceBox's text
    public void setInstanceBox( String text )
    {
        (screenManager.getMainScreen()).getHUD().setInstanceBox( text );
        (screenManager.getMainScreen()).refreshImage();
        screenManager.refreshMe();
    }
    
    // sets the commandBox's text
    public void setCommandBox( String text )
    {
        (screenManager.getMainScreen()).getHUD().setCommandBox( text );
        (screenManager.getMainScreen()).refreshImage();
        screenManager.refreshMe();
    }
    
    // sets the Status Overview info
    public void setStatusOverview( InstanceTypeAndHealth[] instances )
    {
        (screenManager.getMainScreen()).getHUD().setSelectionOverview( instances );
        (screenManager.getMainScreen()).refreshImage();
        screenManager.refreshMe();
    }
    
    public void onTick()
    {
        if ( x < 2 )
        {
            x = 2;
            if ( y < 1 )
            {
                y = 1;
            }
            else if ( y > MHEIGHT - 2 )
            {
                y = MHEIGHT - 2;
            }
        }
        else if ( x > MWIDTH - 3 )
        {
            x = MWIDTH - 3;
            if ( y < 1 )
            {
                y = 1;
            }
            else if ( y > MHEIGHT - 2 )
            {
                y = MHEIGHT - 2;
            }
        }
        else if ( y < 1 )
        {
            y = 1;
        }
        else if ( y > MHEIGHT - 2 )
        {
            y = MHEIGHT - 2;
        }
        ((screenManager.getMainScreen()).getViewPort()).setTiles( tileFetch.getMagicTiles( x - 2,
                                                                                           y - 1,
                                                                                           5, 3 ) );
        
        (screenManager.getMainScreen()).getHUD().setResources(
                                                               new int[]
                                                               {
                                                                   tileFetch.getResourceCount( ResourceType.RED ),
                                                                   tileFetch.getResourceCount( ResourceType.GREEN ),
                                                                   tileFetch.getResourceCount( ResourceType.BLUE )
                                                               } );
        (screenManager.getMainScreen()).refreshImage();
        screenManager.refreshMe();
    }
    
    public void onGameBegin()
    {
        
    }
    
    public void onGameLose()
    {
        
    }
    
    public void onGameWin()
    {
        
    }
    
}
