/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package view;

import model.MagicTile;
import java.awt.image.BufferedImage;
import model.InstanceType;
import model.DecalType;
import model.Alliance;
import model.ResourceType;
import model.TerrainType;
import java.awt.Image;
import javax.imageio.ImageIO;
import java.io.File;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.util.EnumMap;
import java.awt.Font;
import java.awt.Point;

/**
 * 
 * @author spock
 */
class ViewPort
{
    final private static int VPWIDTH = 800;
    final private static int VPHEIGHT = 450;
    
    private GraphicsTable graphicsDecal;
    private GraphicsTable graphicsTerrain;
    private GraphicsTable graphicsInstances;// translates the graphics from the
                                            // enumerations
    private MagicTile[][] curMapSel; // currently viewable tiles with info
    private BufferedImage imageBuffer; // Viewport image
    private Graphics2D graphix;
    private Graphics2D graphiz;
    private Graphics2D graphize;
    private Image ceilingCat;
    private Image duneCat;
    private Image monorailCat;
    private Image tiger;
    private Image pandaBear;
    private Image polarBear;
    private Image outerspace;
    private Image grasslands;
    private Image desert;
    private Image forest;
    private Image plateau;
    private Image hospital;
    private Image paraguay;
    private Image matrix;
    private Image unknown;
    private Image unexp;
    private Image expbas;
    private Image expful;
    private Image redcross;
    private Image skull;
    private BufferedImage alli;
    private BufferedImage hosti;
    private BufferedImage neutri;
    private BufferedImage startScreen;
    
    private boolean showPath = false;
    private int[][] highlightPath;
    
    // constructor
    ViewPort() {
        try
        {
            ceilingCat = ImageIO.read( new File( "view/explore.jpg" ) );
            duneCat = ImageIO.read( new File( "view/wrench.jpg" ) );
            monorailCat = ImageIO.read( new File( "view/ranged2.jpg" ) );
            tiger = ImageIO.read( new File( "view/sword.jpg" ) );
            pandaBear = ImageIO.read( new File( "view/castle.jpg" ) );
            polarBear = ImageIO.read( new File( "view/tower.jpg" ) );
            outerspace = ImageIO.read( new File( "view/outerspaceRV2.jpg" ) );
            grasslands = ImageIO.read( new File( "view/grassRV2.jpg" ) );
            desert = ImageIO.read( new File( "view/desertRV2.jpg" ) );
            forest = ImageIO.read( new File( "view/forestRV2.jpg" ) );
            plateau = ImageIO.read( new File( "view/plateauRV2.jpg" ) );
            hospital = ImageIO.read( new File( "view/hospitalRV2.jpg" ) );
            paraguay = ImageIO.read( new File( "view/ParaguayRV2.jpg" ) );
            matrix = ImageIO.read( new File( "view/matrixRV2.jpg" ) );
            unknown = ImageIO.read( new File( "view/unknownRV2.jpg" ) );
            unexp = ImageIO.read( new File( "view/unexploredDe.jpg" ) );
            expbas = ImageIO.read( new File( "view/exploredBasicDe.jpg" ) );
            expful = ImageIO.read( new File( "view/exploredFullDe.jpg" ) );
            redcross = ImageIO.read( new File( "view/redcrossDe.jpg" ) );
            skull = ImageIO.read( new File( "view/skullDe.jpg" ) );
            
        }
        catch ( Exception c )
        {
            System.out.println( "exception" );
        }
        
        alli = new BufferedImage( 160, 150, BufferedImage.TYPE_INT_ARGB );
        graphiz = alli.createGraphics();
        graphiz.setColor( new Color( 0, 255, 0, 120 ) );
        graphiz.fillRect( 0, 0, 160, 150 );
        
        hosti = new BufferedImage( 160, 150, BufferedImage.TYPE_INT_ARGB );
        graphiz = hosti.createGraphics();
        graphiz.setColor( new Color( 255, 0, 0, 120 ) );
        graphiz.fillRect( 0, 0, 160, 150 );
        
        neutri = new BufferedImage( 160, 150, BufferedImage.TYPE_INT_ARGB );
        graphiz = neutri.createGraphics();
        graphiz.setColor( new Color( 255, 255, 255, 20 ) );
        graphiz.fillRect( 0, 0, 160, 150 );
        
        InstanceType[] ienums = new InstanceType[ 7 ];
        int i = 0;
        for ( InstanceType instanceType : InstanceType.values() )
        {
            ienums[ i ] = instanceType;
            ++i;
        }
        graphicsInstances = new GraphicsTable( ienums, new Image[]
        {
            tiger, monorailCat, duneCat, ceilingCat, pandaBear, polarBear, null
        } );
        
        TerrainType[] tenums = new TerrainType[ 9 ];
        i = 0;
        for ( TerrainType terrainType : TerrainType.values() )
        {
            tenums[ i ] = terrainType;
            ++i;
        }
        graphicsTerrain = new GraphicsTable( tenums, new Image[]
        {
            outerspace, grasslands, desert, forest, plateau, hospital, paraguay, matrix, unknown
        } );
        
        DecalType[] denums = new DecalType[ 5 ];
        i = 0;
        for ( DecalType decalType : DecalType.values() )
        {
            denums[ i ] = decalType;
            ++i;
        }
        graphicsDecal = new GraphicsTable( denums, new Image[]
        {
            unexp, expbas, expful, skull, redcross
        } );
        
        imageBuffer = new BufferedImage( 800, 450, BufferedImage.TYPE_INT_ARGB );
        graphize = (Graphics2D) imageBuffer.getGraphics();
        graphize.setColor( Color.BLACK );
        graphize.fillRect( 0, 0, 800, 450 );
        graphize.setColor( Color.RED );
        Font st = new Font( "Times Roman", Font.BOLD, 30 );
        graphize.setFont( st );
        graphize.drawString( "The Killing Flaming Part-Time Postmen", 75, 200 );
        
    }
    
    void setTiles( MagicTile[][] theGoods )
    {
        curMapSel = theGoods;
        refreshImage();
    }
    
    void setPath( Point[] path, int x, int y )
    {
        if ( path == null || path.length == 0 )
        {
            showPath = false;
        }
        else
        {
            showPath = true;
            highlightPath = new int[ path.length ][ 2 ];
            for ( int j = 0; j < path.length; ++j )
            {
                highlightPath[ j ][ 0 ] = (int) (path[ j ].getX()) - x;
                highlightPath[ j ][ 1 ] = (int) (path[ j ].getY()) - y;
            }
            
        }
    }
    
    // refreshes the viewport's image
    void refreshImage()
    {
        imageBuffer = new BufferedImage( VPWIDTH, VPHEIGHT, BufferedImage.TYPE_INT_ARGB );
        
        graphix = imageBuffer.createGraphics();
        
        graphix.setRenderingHint( RenderingHints.KEY_ANTIALIASING,
                                  RenderingHints.VALUE_ANTIALIAS_ON );
        
        graphix.setStroke( new BasicStroke( 5.0f ) );
        for ( int i = 0; i < 3; ++i )
        {
            for ( int j = 0; j < 5; ++j )
            {
                
                /*
                 * graphix.setColor(Color.WHITE); graphix.fillRect(j*160 + 90,
                 * i*150, 70, 150); graphix.fillRect(j*160 + 40, i*150 + 110,
                 * 50, 40); graphix.fillRect(j*160 + 40, i*150, 50, 50);
                 * graphix.fillRect(j*160, i*150, 40, 110);
                 */

                graphix.drawImage(
                                   graphicsTerrain.getGraphic( curMapSel[ j ][ i ].getTerrain()/*
                                                                                                * TerrainType.
                                                                                                * HOSPITAL
                                                                                                */),
                                   j * 160, i * 150, null );
                
                Alliance ali = curMapSel[ j ][ i ].getAllianceEnum() /*
                                                                      * Alliance.
                                                                      * FRIENDLY
                                                                      */;
                if ( ali == Alliance.NEUTRAL )
                {
                    graphix.drawImage( neutri, j * 160, i * 150, null );
                }
                else if ( ali == Alliance.HOSTILE )
                {
                    graphix.drawImage( hosti, j * 160, i * 150, null );
                }
                else if ( ali == Alliance.FRIENDLY )
                {
                    graphix.drawImage( alli, j * 160, i * 150, null );
                }
                
                graphix.drawImage( graphicsDecal.getGraphic( curMapSel[ j ][ i ].getDecal()/*
                                                                                            * DecalType.
                                                                                            * HEAL_ZONE
                                                                                            */),
                                   j * 160, i * 150 + 110, null );
                graphix.setColor( Color.MAGENTA );
                graphix.setStroke( new BasicStroke( 1.5f ) );
                graphix.drawRect( j * 160, i * 150 + 110, 40, 40 );
                
                // graphix.drawImage(graphicsTerrain.getGraphic(curMapSel[j][i].getTerrain()/*TerrainType.HOSPITAL*/),
                // j*160 + 40, i*150 + 50, null);
                
                // graphix.setColor( Color.ORANGE );
                // graphix.drawRect(j*160 + 40, i*150 + 50, 50, 60);
                
                if ( curMapSel[ j ][ i ].getResourceType() != ResourceType.NONE/* true */)
                {
                    ResourceType res = curMapSel[ j ][ i ].getResourceType() /*
                                                                              * ResourceType.
                                                                              * BLUE
                                                                              */;
                    if ( res == ResourceType.RED )
                    {
                        graphix.setColor( Color.RED );
                    }
                    else if ( res == ResourceType.GREEN )
                    {
                        graphix.setColor( Color.GREEN );
                    }
                    else if ( res == ResourceType.BLUE )
                    {
                        graphix.setColor( Color.BLUE );
                    }
                    graphix.fill( new Ellipse2D.Double( j * 160 + 40 + 12, i * 150 + 12, 25, 25 ) );
                }
                
                EnumMap heyo = curMapSel[ j ][ i ].getUnits();
                
                Font f1 = new Font( "Times Roman", Font.BOLD, 13 );
                graphix.setFont( f1 );
                graphix.setColor( Color.BLACK );
                graphix.setColor( Color.BLUE );
                graphix.setStroke( new BasicStroke( 1.5f ) );
                if ( heyo.get( InstanceType.EXPLORER ) != null )
                {
                    graphix.drawImage( graphicsInstances.getGraphic( InstanceType.EXPLORER ),
                                       j * 160 + 95, i * 150 + 7, null );
                    graphix.drawRect( j * 160 + 95, i * 150 + 7, 40, 30 );
                    graphix.setColor( Color.WHITE );
                    graphix.fillRect( j * 160 + 138, i * 150 + 23, 20, 15 );
                    graphix.setColor( Color.BLUE );
                    graphix.drawRect( j * 160 + 138, i * 150 + 23, 20, 15 );
                    graphix.setColor( Color.BLACK );
                    graphix.drawString( " " + /* b */heyo.get( InstanceType.EXPLORER ),
                                        j * 160 + 138, i * 150 + 37 );
                }
                graphix.setColor( Color.BLUE );
                if ( heyo.get( InstanceType.COLONIST ) != null )
                {
                    graphix.drawImage( graphicsInstances.getGraphic( InstanceType.COLONIST ),
                                       j * 160 + 95, i * 150 + 42, null );
                    graphix.drawRect( j * 160 + 95, i * 150 + 42, 40, 30 );
                    graphix.setColor( Color.WHITE );
                    graphix.fillRect( j * 160 + 138, i * 150 + 58, 20, 15 );
                    graphix.setColor( Color.BLUE );
                    graphix.drawRect( j * 160 + 138, i * 150 + 58, 20, 15 );
                    graphix.setColor( Color.BLACK );
                    graphix.drawString( " " + /* b */heyo.get( InstanceType.COLONIST ),
                                        j * 160 + 138, i * 150 + 72 );
                }
                graphix.setColor( Color.BLUE );
                if ( heyo.get( InstanceType.MELEE ) != null )
                {
                    graphix.drawImage( graphicsInstances.getGraphic( InstanceType.MELEE ),
                                       j * 160 + 95, i * 150 + 77, null );
                    graphix.drawRect( j * 160 + 95, i * 150 + 77, 40, 30 );
                    graphix.setColor( Color.WHITE );
                    graphix.fillRect( j * 160 + 138, i * 150 + 93, 20, 15 );
                    graphix.setColor( Color.BLUE );
                    graphix.drawRect( j * 160 + 138, i * 150 + 93, 20, 15 );
                    graphix.setColor( Color.BLACK );
                    graphix.drawString( " " + /* b */heyo.get( InstanceType.MELEE ), j * 160 + 138,
                                        i * 150 + 107 );
                }
                graphix.setColor( Color.BLUE );
                if ( heyo.get( InstanceType.RANGED ) != null )
                {
                    graphix.drawImage( graphicsInstances.getGraphic( InstanceType.RANGED ),
                                       j * 160 + 95, i * 150 + 112, null );
                    graphix.drawRect( j * 160 + 95, i * 150 + 112, 40, 30 );
                    graphix.setColor( Color.WHITE );
                    graphix.fillRect( j * 160 + 138, i * 150 + 128, 20, 15 );
                    graphix.setColor( Color.BLUE );
                    graphix.drawRect( j * 160 + 138, i * 150 + 128, 20, 15 );
                    graphix.setColor( Color.BLACK );
                    graphix.drawString( " " + /* b */heyo.get( InstanceType.RANGED ),
                                        j * 160 + 138, i * 150 + 142 );
                }
                graphix.setColor( Color.BLUE );
                if ( curMapSel[ j ][ i ].getStructure() != InstanceType.NULL )
                {
                    graphix.drawImage(
                                       graphicsInstances.getGraphic( /*
                                                                      * InstanceType.
                                                                      * BASE
                                                                      */curMapSel[ i ][ j ].getStructure() ),
                                       j * 160 + 45, i * 150 + 115, null );
                    graphix.drawRect( j * 160 + 45, i * 150 + 115, 40, 30 );
                }
                
                int[] RP = /* new int[] {1,2,5,7, 6, 10} */curMapSel[ j ][ i ].getRallyPoints();
                
                f1 = new Font( "Times Roman", Font.BOLD, 15 );
                graphix.setFont( f1 );
                
                if ( RP != null && RP.length > 0 )
                {
                    graphix.setColor( Color.WHITE );
                    graphix.fillRect( j * 160 + 4, i * 150, 23, 20 );
                    graphix.setColor( Color.BLACK );
                    graphix.drawRect( j * 160 + 4, i * 150, 23, 20 );
                    graphix.drawString( "RP:", j * 160 + 4, i * 150 + 17 );
                }
                
                f1 = new Font( "Times Roman", Font.PLAIN, 10 );
                graphix.setFont( f1 );
                
                for ( int h = 0; RP != null && h < RP.length; ++h )
                {
                    if ( h < 5 )
                    {
                        graphix.setColor( Color.WHITE );
                        graphix.fillRect( j * 160 + 4, i * 150 + 36 + h * 14 - 10, 15, 12 );
                        graphix.setColor( Color.BLACK );
                        graphix.drawString( "" + RP[ h ], j * 160 + 4, i * 150 + 36 + h * 14 );
                    }
                    else
                    {
                        graphix.setColor( Color.WHITE );
                        graphix.fillRect( j * 160 + 20, i * 150 + 36 + h * 14 - 10, 15, 12 );
                        graphix.setColor( Color.BLACK );
                        graphix.drawString( "" + RP[ h ], j * 160 + 20, i * 150 + 36 + (h - 5) * 14 );
                        
                    }
                }
                
            }
        }
        
        graphix.setColor( Color.BLACK );
        graphix.setStroke( new BasicStroke( 5.0f ) );
        graphix.drawLine( 0, 0, VPWIDTH, 0 );
        graphix.drawLine( 0, 150, VPWIDTH, 150 );
        graphix.drawLine( 0, 300, VPWIDTH, 300 );
        graphix.drawLine( 0, VPHEIGHT, VPWIDTH, VPHEIGHT );
        
        graphix.drawLine( 0, 0, 0, VPHEIGHT );
        graphix.drawLine( 160, 0, 160, VPHEIGHT );
        graphix.drawLine( 320, 0, 320, VPHEIGHT );
        graphix.drawLine( 480, 0, 480, VPHEIGHT );
        graphix.drawLine( 640, 0, 640, VPHEIGHT );
        graphix.drawLine( VPWIDTH, 0, VPWIDTH, VPHEIGHT );
        
        graphix.setColor( Color.YELLOW );
        graphix.setStroke( new BasicStroke( 5.0f ) );
        if ( showPath )
        {
            for ( int i = 0; i < highlightPath.length; ++i )
            {
                graphix.drawRect( highlightPath[ i ][ 0 ] * 160, highlightPath[ i ][ 1 ] * 150,
                                  160, 150 );
            }
        }
        
    }
    
    // gets the image of the Viewport
    BufferedImage getImage()
    {
        return imageBuffer;
    }
    
}
