package com.ouroboroswiki.core;

import java.util.Collection;
import java.util.Date;
import java.util.Map;

public abstract class AbstractContent implements Content {
	
	private boolean exists;
	private String humanReadableName;
	private String mimeType;
	private String uniqueName;
	private String repositoryName;
	
	private boolean readable;
	private boolean writable;
	private boolean dynamic;
	private Object version;
	private User updateEditor;
	private Date updateTime;
	
	private Collection<ContentValidationResult> validationResults;
	
	public AbstractContent()  {
	
	}
	
	

	@Override
	public Content getChildContent(String name) {
		Map<String, Content> childContent = getChildContent();
		Content result;
		if( childContent != null ) {
			result = childContent.get(name);
		} else {
			result = null;
		}
		return result;
	}



	@Override
	public boolean exists() {
		return exists;
	}
	
	public void setExists( boolean exists ) {
		this.exists = exists;
	}
	
	public void setHumanReadableName( String humanReadableName ) {
		this.humanReadableName = humanReadableName;
	}
	
	
	@Override
	public String getRepositoryName() {
		return this.repositoryName;
	}
	
	public void setRepositoryName( String repositoryName ) {
		this.repositoryName = repositoryName;
	}

	@Override
	public String getMimeType() {
		return this.mimeType;
	}
	
	public void setMimeType( String mimeType ) {
		this.mimeType = mimeType;
	}

	@Override
	public String getUniqueName() {
		return this.uniqueName;
	}
	
	public void setUniqueName( String uniqueName ) {
		this.uniqueName = uniqueName;
	}

	@Override
	public User getUpdateEditor() {
		return this.updateEditor;
	}
	
	public void setUpdatedEditor( User updateEditor ) {
		this.updateEditor = updateEditor;
	}

	@Override
	public Date getUpdateTime() {
		return this.updateTime;
	}
	
	public void setUpdateTime( Date updateTime ) {
		this.updateTime = updateTime;
	}

	@Override
	public Object getVersion() {
		return this.version;
	}
	
	public void setVersion( Object version ) {
		this.version = version;
	}

	@Override
	public boolean isReadable() {
		return this.readable;
	}
	
	public void setReadable( boolean readable ) {
		this.readable = readable;
	}

	@Override
	public boolean isDynamic() {
		return dynamic;
	}
	
	public void setDynamic( boolean dynamic ) {
		this.dynamic = dynamic;
	}


	@Override
	public boolean isWritable() {
		return this.writable;
	}
	
	public void setWritable( boolean writable ) {
		this.writable = writable;
	}
	
	@Override
	public Collection<ContentValidationResult> getValidationResults() {
		return this.validationResults;
	}
	
	public void setValidationResults( Collection<ContentValidationResult> validationResults ) {
		this.validationResults = validationResults;
	}

	@Override
	public String toString() {
		return ""+this.repositoryName +":"+this.uniqueName; 
	}
	

	
}
