package com.ouroboroswiki.core;

import java.util.Map;


public interface ContentRepository {
	
	String getName();
	
	String getDescription();
	
	Content getContent(Object principal, ContentPath path, Version version, Map<String, Object> properties) throws ContentException;
	
	boolean exists(Object principal,ContentPath path) throws ContentException;
	
	Version buildVersion(Object principal, ContentPath path, String[] versionPath, VersionBuilder versionBuilder) throws ContentException;
}
