package com.ouroboroswiki.core.content;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;

import com.ouroboroswiki.core.AbstractContent;
import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;

public class CompositeContent extends AbstractContent {
	
	private Map<String, Content> childContent;
	
	public CompositeContent( Map<String, Content> childContent ) {
		this.childContent = childContent;
	}

	@Override
	public Map<String, Content> getChildContent() {
		return this.childContent;
	}

	@Override
	public void write(OutputStream outs) throws IOException, ContentException {
		Collection<Content> contents = childContent.values();
		for( Content content : contents ) {
			content.write( outs );
		}
	}

}
