package com.ouroboroswiki.core.content;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ouroboroswiki.core.ContentRepository;
import com.ouroboroswiki.core.ContentRepositoryFactory;

public class DefaultContentRepositoryFactory implements ContentRepositoryFactory {
	private Map<String, ContentRepository> repositories;
	
	public DefaultContentRepositoryFactory() {
	}
	
	public ContentRepository getRepository( String name ) {
		return repositories.get(name);
	}
	
	public Collection<ContentRepository> getRepositories() {
		return repositories.values();
	}
	
	public void setRepositoriesAsList(List<ContentRepository> repositories) {
		this.repositories = new HashMap<String, ContentRepository>(repositories.size());		
		for( ContentRepository repository : repositories ) {
			this.repositories.put( repository.getName(), repository );
		}
	}
}
