package com.ouroboroswiki.core.content;

import java.util.Map;

import com.ouroboroswiki.core.AbstractContentRepositoryProxy;
import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;
import com.ouroboroswiki.core.ContentPath;
import com.ouroboroswiki.core.Version;
import com.ouroboroswiki.core.VersionBuilder;

public class PrefixPathStepContentRepositoryProxy extends AbstractContentRepositoryProxy {
	
	private String[] prefix;
	
	public PrefixPathStepContentRepositoryProxy( String[] prefix ) {
		this.prefix = prefix;
	}
	
	@Override
	public Version buildVersion(Object principal, ContentPath path,
			String[] versionPath, VersionBuilder versionBuilder)
			throws ContentException {
		ContentPath newPath = toPath( path );
		return proxied.buildVersion(principal, newPath, versionPath, versionBuilder);
	}

	@Override
	public boolean exists(Object principal, ContentPath path)
			throws ContentException {
		ContentPath newPath = toPath( path );
		return proxied.exists(principal, newPath);
	}

	@Override
	public Content getContent(Object principal, ContentPath path, Version version,
			Map<String, Object> properties) throws ContentException {
		ContentPath newPath = toPath( path );
		return proxied.getContent(principal, newPath, version, properties);
	}

	public ContentPath toPath( ContentPath path ) {
		ContentPath result = path;
		for( int i=0; i<prefix.length; i++ ) {
			result = new ContentPath( prefix[i], result );
		}
		return result;
	}
}
