package com.ouroboroswiki.core.content;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

import com.ouroboroswiki.core.AbstractContent;
import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;

public class StaticContent extends AbstractContent {
	
	private byte[] data;
	private Map<String, Content> childContent;
	
	public StaticContent( byte[] data ) {
		this.data = data;
	}
	
	@Override
	public Map<String, Content> getChildContent() {
		return this.childContent;
	}
	
	public void setChildContent( Map<String, Content> childContent ) {
		this.childContent = childContent;
	}

	@Override
	public void write(OutputStream outs) throws IOException, ContentException {
		outs.write( data );
	}

}
