package com.ouroboroswiki.core.content.markup.processor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;

import com.ouroboroswiki.core.AbstractContent;
import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;

public class MarkupContent extends AbstractContent {

	private Document document;
	private Map<String, Content> childContent;
	private TransformerFactory transformerFactory;
	
	public MarkupContent( Document document, Map<String, Content> childContent, TransformerFactory transformerFactory ) {
		this.document = document;
		this.childContent = childContent;
		this.transformerFactory = transformerFactory;
	}

	@Override
	public Map<String, Content> getChildContent() {
		return childContent;
	}

	@Override
	public void write( OutputStream outs ) throws IOException, ContentException {
		Transformer transformer;
		try {
			transformer = transformerFactory.newTransformer();
		} catch (TransformerConfigurationException ex ) {
			throw new ContentException( "unable to create transformer" );
		}
		DOMSource source = new DOMSource(document);
		StreamResult result = new StreamResult(outs); 
		try {
			transformer.transform(source, result);
		} catch( TransformerException ex ) {
			throw new ContentException( "unable to transform content" );
		}
	}
	
	

}
