package com.ouroboroswiki.core.content.xml;

import java.util.Map;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;

import com.ouroboroswiki.core.AbstractContentRepository;
import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;
import com.ouroboroswiki.core.ContentPath;
import com.ouroboroswiki.core.ContentRepository;
import com.ouroboroswiki.core.Version;
import com.ouroboroswiki.core.VersionBuilder;

public class XMLMetadataContentRepositoryProxy extends AbstractContentRepository {
	
	private DocumentBuilderFactory documentBuilderFactory;
	private TransformerFactory transformerFactory;
	private ContentRepository proxied;
	
	public XMLMetadataContentRepositoryProxy( String name, DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory ) {
		this.setName( name );
		this.documentBuilderFactory = documentBuilderFactory;
		this.transformerFactory = transformerFactory;
	}
	
	public ContentRepository getProxied() {
		return proxied;
	}

	public void setProxied(ContentRepository proxied) {
		this.proxied = proxied;
	}

	@Override
	public Version buildVersion(Object principal,ContentPath path,
			String[] versionPath, VersionBuilder versionBuilder)
			throws ContentException {
		return proxied.buildVersion(principal, path, versionPath, versionBuilder);
	}

	@Override
	public boolean exists(Object principal, ContentPath path)
			throws ContentException {
		return proxied.exists(principal, path);
	}

	@Override
	public Content getContent(Object principal, ContentPath path, Version version,
			Map<String, Object> properties) throws ContentException {
		Content proxiedContent = proxied.getContent(principal, path, version, properties);
		XMLMetadataContent content = new XMLMetadataContent(proxiedContent, documentBuilderFactory, transformerFactory);
		content.setRepositoryName(this.getName());
		content.setExists(proxiedContent.exists());
		content.setMimeType("text/xml");
		content.setUniqueName(path.toString());
		return content;
	}
}
