package com.ouroboroswiki.core.content.xml;

import java.util.Map;

import com.ouroboroswiki.core.AbstractContentRepository;
import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;
import com.ouroboroswiki.core.ContentPath;
import com.ouroboroswiki.core.ContentRepository;
import com.ouroboroswiki.core.Version;
import com.ouroboroswiki.core.VersionBuilder;
import com.ouroboroswiki.core.filter.Filter;

public class XMLTaggingContentRepositoryProxy extends AbstractContentRepository {

	private ContentRepository proxied;
	private String elementName;
	private String mimeType;
	private Filter<String> mimeFilter;
	
	public XMLTaggingContentRepositoryProxy() {
		
	}
	
	public XMLTaggingContentRepositoryProxy( ContentRepository proxied ) {
		this.proxied = proxied;
	}
	
	public void setProxied( ContentRepository proxied ) {
		this.proxied = proxied;
	}
	
	public Filter<String> getMimeFilter() {
		return this.mimeFilter;
	}
	
	public void setMimeFilter( Filter<String> mimeFilter ) {
		this.mimeFilter = mimeFilter;
	}
	
	public String getElementName() {
		return elementName;
	}

	public void setElementName(String elementName) {
		this.elementName = elementName;
	}

	public String getMimeType() {
		return this.mimeType;
	}
	
	public void setMimeType( String mimeType ) {
		this.mimeType = mimeType;
	}
	
	@Override
	public boolean exists(Object principal,ContentPath path) throws ContentException {
		return proxied.exists(principal, path);
	}

	@Override
	public Content getContent(Object principal, ContentPath path, Version version, Map<String, Object> properties)
			throws ContentException {
		Content content = proxied.getContent(principal, path, version, properties);
		if( content != null ) {
			String elementName;
			if( this.elementName != null ) {
				elementName = this.elementName;
			} else {
				elementName = path.getName();
			}
			XMLTaggingContentProxy proxy = new XMLTaggingContentProxy( content, elementName, true );
			if( this.mimeType != null ) {
				proxy.setMimeType( this.mimeType );
			}
			proxy.setMimeFilter(mimeFilter);
			return proxy;
		} else {
			return null;
		}
	}



	@Override
	public Version buildVersion(Object principal, ContentPath path,
			String[] versionPath, VersionBuilder versionBuilder) throws ContentException {
		return proxied.buildVersion(principal, path, versionPath, versionBuilder);
	}
	
	

}
