package com.ouroboroswiki.core.content.xslt.fop;

import java.io.OutputStream;

import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;

import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;

import com.ouroboroswiki.core.Content;
import com.ouroboroswiki.core.ContentException;
import com.ouroboroswiki.core.content.xslt.XSLTContent;

public class XSLFOContent extends XSLTContent {
	
	public XSLFOContent( Content xmlContent, Content xslContent, Content propertiesContent ) {
		super( xmlContent, xslContent, propertiesContent );
	}

	@Override
	protected Result getResult(OutputStream outs) throws ContentException {
		try {
			FopFactory fopFactory = FopFactory.newInstance();
			fopFactory.setURIResolver(this.uriResolver);
			Fop fop = fopFactory.newFop(getMimeType(), outs);
			return new SAXResult(fop.getDefaultHandler());
		} catch( FOPException ex ) {
			throw new ContentException( "unable to generate FOP", ex );
		}
	}
	
	
}
