package com.ouroboroswiki.core.filter;

import java.util.Set;

public class MimeTypePrefixFilter implements Filter<String> {
	
	private Set<String> prefixes;
	
	public MimeTypePrefixFilter( Set<String> prefixes ) {
		this.prefixes = prefixes;
	}

	@Override
	public boolean accept(String o) {
		int index = o.indexOf('/');
		String prefix;
		if( index < 0 ) {
			prefix = o;
		} else {
			prefix = o.substring(0, index);
		}
		return prefixes.contains(prefix);
	}

}
