package deitelServer;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Server extends JFrame {
	private JTextField enterField;
	private JTextArea displayArea;
	private ObjectInputStream imput;
	private ObjectOutputStream output;
	private ServerSocket server;
	private Socket connection;
	private int conter = 1;
	public Server(){
		super("Server");
		enterField = new JTextField();
		enterField.setEditable(false);
		enterField.addActionListener(
				new ActionListener() {
					
					@Override
					public void actionPerformed(ActionEvent event) {
						sendData(event.getActionCommand());
						enterField.setText("");
						
					}
				});
		add(enterField, BorderLayout.NORTH);
		displayArea = new JTextArea();
		add(new JScrollPane(displayArea), BorderLayout.NORTH);
		setSize(300, 150);
		setVisible(true);
	}
	public void runServer(){
		try {
			server = new ServerSocket(12345, 100);
			while(true){
				try{
					waitForConnection();
					getStreams();
					processConnection();
				}
				catch(EOFException eofeExcepition){
					displayMessage("\nServer Terminat Connection");
				}
				finally{
					closeConnection();
					++conter;
				}
			}
		} catch (IOException ioexcepition) {
			ioexcepition.printStackTrace();
		}
	}
	private void waitForConnection() throws IOException{
		displayMessage("Waiting for Connection\n");
		connection = server.accept();
		displayMessage("Connection "+conter+"received from: "+connection.getInetAddress().getHostName());
	}
	private void getStreams() throws IOException{
		output = new ObjectOutputStream(connection.getOutputStream());
		output.flush();
		imput = new ObjectInputStream(connection.getInputStream());
		displayMessage("\nGo I/O streams\n");
	}
	private void processConnection() throws IOException{
		String message = "Connection sucessful";
		sendData( message );
		setTextFieldEditable(true);
		do{
			try{
				message = (String) imput.readObject();
				displayMessage("\n"+message);
			}
			catch(ClassNotFoundException classNotFoundException){
				displayMessage("\nUnknown object type received");
			}
		}while(!message.equals("CLIENT>>> TERMINATE"));
	}
	private void closeConnection(){
		displayMessage("\nTeminat connection\n");
		setTextFieldEditable(false);
		try{
			output.close();
			imput.close();
			connection.close();
		}catch(IOException iOException){
			iOException.printStackTrace();
		}
	}
	private void sendData(String message){
		try{
			output.writeObject("SERVER>>"+message);
			output.flush();
			displayMessage("\nSERVER>>"+message);
		}catch(IOException iOException){
			displayArea.append("\nError writeng object");
		}
	}
	private void displayMessage(final String massageToDisplay){
		SwingUtilities.invokeLater(
				new Runnable() {
					
					@Override
					public void run() {
						displayArea.append(massageToDisplay);
						
					}
				}
				);
	}
	public void setTextFieldEditable(final boolean editable){
		SwingUtilities.invokeLater(
				new Runnable() {
					
					@Override
					public void run() {
						enterField.setEditable(editable);
						
					}
				}
				);
	}
}
