package com.prolixtech.utils;


/**
 * This class provides a single logging utility used for debugging purposes. It
 * delegates most of its work to the java logging system, however it is made a
 * singleton here so that it can be used throughout the application.
 * 
 * @author Constantinos Michael
 * 
 * 
 */
public class SingletonLogger extends NullLogger {
    
    private static MboxLogger inst = NullLogger.Instance();
    private static boolean log;
    
    public static void setLog(boolean x){
        if(log!=x){
            if(x){
                inst = JavaLogger.Instance();
            } else {
                inst = NullLogger.Instance();
            }
        }
        log=x;
    }
    
    public static MboxLogger Instance(){
        return inst;
    }
    
    public SingletonLogger(){
        //
    }

}