//#########################################################################
//        p2pSL-jserver
//
// (C) Copyright by hachreak
//       Released under GPL v2.
//       Author : Hachreak (hachreak at gmail dot com)
//       WebSite: www.secondlifelab.it
//       Date: 31/lug/07 - 14:54:13
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
//#########################################################################

/**
 *  31/lug/07 - 14:54:13
 *  Create by hachreak
 *  Under GPL V2 license
 */

package it.secondlifelab.p2pSL.jInterface;

import it.secondlifelab.p2pSL.jserver.Debug;
import it.secondlifelab.p2pSL.jserver.DirectoryLoader;
import it.secondlifelab.p2pSL.jserver.DirectorySaver;
import it.secondlifelab.p2pSL.jserver.P2PSLconfig;
import it.secondlifelab.p2pSL.jserver.P2PSLphpInterface;
import it.secondlifelab.p2pSL.jserver.Server;

import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.Ostermiller.util.MD5;
import com.prolixtech.jaminid.ConnectionListener;
import com.prolixtech.jaminid.Daemon;

/**
 * @author hachreak
 * 
 * Main class for graphic interface
 */
public class MainInterface extends JFrame {

	protected static final String PASSWORD_DEFINED = "***************";

	private static final long serialVersionUID = 1L;

	private JPanel jContentPane = null;

	private JTabbedPane jTabbedPane = null;

	private JPanel jPanel = null;

	private JPanel jPanel1 = null;

	private JPanel jPanel2 = null;

	private JSplitPane jSplitPane = null;

	private JPanel jPanel3 = null;

	private JTextArea jTextArea = null;

	private JToggleButton jToggleButton = null;

	private JButton jButton = null;

	private JLabel jLabel = null;

	private JTextField jTextField = null;

	private JLabel jLabel1 = null;

	private JList jList = null;

	private JButton jButton1 = null;

	private JPanel jPanel4 = null;

	private JButton jButton2 = null;

	private JButton jButton3 = null;

	private DefaultListModel listModel;

	private JButton jButton4 = null;

	private JScrollPane jScrollPane = null;

	private Server server; // @jve:decl-index=0:

	private boolean isActive = false;

	protected Debug vdebug = new VisualDebug(getJTextArea());
	
	private JScrollPane jScrollPane1 = null;

	private JMenuBar jJMenuBar = null;

	private JMenu jMenu = null;

	private JMenu jMenu1 = null;

	private JMenuItem jMenuItem = null;

	private JMenuItem jMenuItem1 = null;

	private JMenuItem jMenuItem2 = null;

	private JButton jButton5 = null;

	private JLabel jLabel2 = null;

	private JPasswordField jPasswordField = null;

	private JLabel jLabel3 = null;

	private JTextField jTextField1 = null;

	private P2PSLconfig config = null;

	private JButton jButton6 = null;

	private JLabel jLabel4 = null;

	private JTextField jTextField2 = null;

	private JPanel jPanel5 = null;

	protected Daemon daemon;

	private JLabel jLabel5 = null;

	private JCheckBox jCheckBox = null;

	protected boolean isStarted = false;

	/**
	 * @throws HeadlessException
	 * @throws IOException
	 */
	public MainInterface() throws HeadlessException, IOException {
		// TODO Auto-generated constructor stub
		super();
		initialize();
	}

	/**
	 * @param gc
	 * @throws IOException
	 */
	public MainInterface(GraphicsConfiguration gc) throws IOException {
		super(gc);
		// TODO Auto-generated constructor stub
		initialize();
	}

	/**
	 * @param title
	 * @throws HeadlessException
	 * @throws IOException
	 */
	public MainInterface(String title) throws HeadlessException, IOException {
		super(title);
		// TODO Auto-generated constructor stub
		initialize();
	}

	/**
	 * @param title
	 * @param gc
	 * @throws IOException
	 */
	public MainInterface(String title, GraphicsConfiguration gc)
			throws IOException {
		super(title, gc);
		// TODO Auto-generated constructor stub
		initialize();
	}

	/**
	 * This method initializes jTabbedPane
	 * 
	 * @return javax.swing.JTabbedPane
	 * @throws IOException
	 */
	private JTabbedPane getJTabbedPane() throws IOException {
		if (jTabbedPane == null) {
			jTabbedPane = new JTabbedPane();
			jTabbedPane.setName("Main");
			jTabbedPane.setToolTipText("Main");
			jTabbedPane.addTab("Main", null, getJPanel1(), null);
			jTabbedPane.addTab("Share", null, getJPanel2(), null);
		}
		return jTabbedPane;
	}

	/**
	 * This method initializes jPanel
	 * 
	 * @return javax.swing.JPanel
	 * @throws IOException
	 */
	private JPanel getJPanel() throws IOException {
		if (jPanel == null) {
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.fill = GridBagConstraints.BOTH;
			gridBagConstraints.weighty = 1.0;
			gridBagConstraints.gridheight = 2;
			gridBagConstraints.weightx = 1.0;
			jPanel = new JPanel();
			jPanel.setLayout(new GridBagLayout());
			jPanel.add(getJTabbedPane(), gridBagConstraints);
		}
		return jPanel;
	}

	/**
	 * This method initializes jPanel1
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel1() {
		if (jPanel1 == null) {
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.fill = GridBagConstraints.VERTICAL;
			gridBagConstraints2.gridy = -1;
			gridBagConstraints2.weightx = 1.0;
			gridBagConstraints2.gridx = -1;
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.weighty = 1.0;
			gridBagConstraints1.weightx = 1.0;
			jPanel1 = new JPanel();
			jPanel1.setLayout(new GridBagLayout());
			jPanel1.add(getJSplitPane(), gridBagConstraints1);
		}
		return jPanel1;
	}

	/**
	 * This method initializes jPanel2
	 * 
	 * @return javax.swing.JPanel
	 * @throws IOException
	 */
	private JPanel getJPanel2() throws IOException {
		if (jPanel2 == null) {
			jPanel2 = new JPanel();
			jPanel2.setLayout(new BorderLayout());
			jPanel2.add(getJScrollPane(), BorderLayout.CENTER);
			jPanel2.add(getJPanel4(), BorderLayout.SOUTH);
		}
		return jPanel2;
	}

	/**
	 * This method initializes jSplitPane
	 * 
	 * @return javax.swing.JSplitPane
	 */
	private JSplitPane getJSplitPane() {
		if (jSplitPane == null) {
			jSplitPane = new JSplitPane();
			jSplitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
			jSplitPane.setOneTouchExpandable(true);
			jSplitPane.setResizeWeight(0.6D);
			jSplitPane.setBottomComponent(getJScrollPane1());
			jSplitPane.setTopComponent(getJPanel3());
		}
		return jSplitPane;
	}

	/**
	 * This method initializes jPanel3
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel3() {
		if (jPanel3 == null) {
			jLabel5 = new JLabel();
			jLabel5.setText("AutoConnect");
			GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
			gridBagConstraints16.gridheight = 4;
			gridBagConstraints16.gridwidth = 4;
			jLabel4 = new JLabel();
			jLabel4.setText("Server PHP");
			jLabel4
					.setToolTipText("Server php for exchange with SL object info of position");
			GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
			gridBagConstraints13.gridy = 11;
			gridBagConstraints13.gridx = 3;
			jLabel3 = new JLabel();
			jLabel3.setText("SL Name");
			jLabel3.setToolTipText("SecondLife Name and Surname");
			jLabel2 = new JLabel();
			jLabel2.setText("Password");
			GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
			gridBagConstraints8.gridx = 2;
			gridBagConstraints8.gridy = 11;
			GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
			gridBagConstraints7.gridx = 1;
			gridBagConstraints7.gridy = 10;
			jLabel1 = new JLabel();
			jLabel1.setText(" ");
			jLabel1.setEnabled(false);
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.gridx = 1;
			gridBagConstraints6.gridy = 11;
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.gridx = 0;
			gridBagConstraints5.gridy = 11;
			jLabel = new JLabel();
			jLabel.setText("Port");
			jLabel.setToolTipText("Select port for server");
			jPanel3 = new JPanel();
			jPanel3.setLayout(new GridBagLayout());
			jPanel3.add(getJToggleButton(), gridBagConstraints5);
			jPanel3.add(getJButton(), gridBagConstraints6);
			jPanel3.add(jLabel1, gridBagConstraints7);
			jPanel3.add(getJButton5(), gridBagConstraints8);
			jPanel3.add(getJButton6(), gridBagConstraints13);
			jPanel3.add(getJPanel5(), gridBagConstraints16);
		}
		return jPanel3;
	}

	/**
	 * This method initializes jTextArea
	 * 
	 * @return javax.swing.JTextArea
	 */
	private JTextArea getJTextArea() {
		if (jTextArea == null) {
			jTextArea = new JTextArea();
		}
		return jTextArea;
	}

	/**
	 * This method initializes jToggleButton
	 * 
	 * @return javax.swing.JToggleButton
	 */
	private JToggleButton getJToggleButton() {
		if (jToggleButton == null) {
			jToggleButton = new JToggleButton();
			jToggleButton.setText(" Start ");
			jToggleButton.setToolTipText("Start  the P2PSL-jserver");

			jToggleButton.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					if (isActive) {
						isActive = false;

						jToggleButton.setText("Start");

						if (daemon != null) {
							daemon.tearDown();
							daemon.interrupt();

							try {
								// Chiudi il socket aperto
								new URL("http://127.0.0.1:8880/ping")
										.getContent();
							} catch (IOException e1) {
								// TODO Auto-generated catch block
								e1.printStackTrace();
							}
						}
						// System.out.println("down");
						// server.interrupt();

						vdebug.print("[ OK ] Server stopped ");
					} else {
						jToggleButton.setText("Stop");

						try {
							isActive = true;

							server = new Server(vdebug, config);
							daemon = new Daemon(config.getPort(), server,
									new ConnectionListener() {

										public void close() {
											System.out.println(jToggleButton
													.isSelected());
											if (jToggleButton.isSelected()) {
												jToggleButton.doClick();// .setText("Start");
												// isActive = false;
											}

										}

										public void open(String server) {
											vdebug.print("Open connection: "
													+ server);
										}

									});

						} catch (IOException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
							vdebug.print("[ ERROR ] Can't start Server");
						}
						// server.start();

						vdebug.print("[ OK ] Server started ");
					}
				}

			});
		}
		return jToggleButton;
	}

	/**
	 * This method initializes jButton
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButton() {
		if (jButton == null) {
			jButton = new JButton();
			jButton.setText("Restart");
			jButton.setToolTipText("Restart  the P2PSL-jserver");

			jButton.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					if (isActive) {
						jToggleButton.doClick();
					}

					jToggleButton.doClick();
				}
			});
		}
		return jButton;
	}

	/**
	 * This method initializes jTextField
	 * 
	 * @return javax.swing.JTextField
	 */
	private JTextField getJTextField() {
		if (jTextField == null) {
			jTextField = new JTextField();
			jTextField.setToolTipText("Port for the Server");
			jTextField.setText(Integer.toString(config.getPort()));
			jTextField.setHorizontalAlignment(JTextField.LEFT);
			jTextField.setColumns(5);
		}
		return jTextField;
	}

	/**
	 * This method initializes jList
	 * 
	 * @return javax.swing.JList
	 * @throws IOException
	 */
	private JList getJList() throws IOException {
		if (jList == null) {
			// Carico la lista
			DirectoryLoader d = new DirectoryLoader();
			Iterator<String> i = d.getDirectoriesShared().iterator();
			listModel = new DefaultListModel();
			while (i.hasNext()) {
				String text = i.next();
				// System.out.println(text);
				listModel.addElement(text);
			}
			jList = new JList(listModel);
			jList.setName("directories shared");
			jList.setToolTipText("Directories Shared");
			// i.next();
		}
		return jList;
	}

	/**
	 * This method initializes jButton1
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButton1() {
		if (jButton1 == null) {
			jButton1 = new JButton();
			jButton1.setText("Add");
		}

		jButton1.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				// TODO Auto-generated method stub
				JFileChooser jfc = new JFileChooser();
				jfc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				jfc.setApproveButtonText("Add");

				// JFrame fr = new JFrame();
				// fr.getContentPane().add(jfc);

				// int ret = jfc.showOpenDialog(fr);

				addListModel(jfc);
			}

		});

		return jButton1;
	}

	/**
	 * This method initializes jPanel4
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel4() {
		if (jPanel4 == null) {
			jPanel4 = new JPanel();
			jPanel4.setLayout(new GridBagLayout());
			jPanel4.add(getJButton4(), new GridBagConstraints());
			jPanel4.add(getJButton1(), new GridBagConstraints());
			jPanel4.add(getJButton2(), new GridBagConstraints());
			jPanel4.add(getJButton3(), new GridBagConstraints());
		}
		return jPanel4;
	}

	/**
	 * This method initializes jButton2
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButton2() {
		if (jButton2 == null) {
			jButton2 = new JButton();
			jButton2.setText("Edit");

			if (jList.isSelectionEmpty())
				jButton2.setEnabled(false);

			jList.addListSelectionListener(new ListSelectionListener() {

				public void valueChanged(ListSelectionEvent e) {
					// TODO Auto-generated method stub
					if (!jList.isSelectionEmpty())
						jButton2.setEnabled(true);
					else
						jButton2.setEnabled(false);
				}

			});

			jButton2.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					int index = jList.getSelectedIndex();
					String file_old = (String) listModel.get(index);

					JFileChooser jfc = new JFileChooser();
					jfc
							.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
					jfc.setApproveButtonText("Modify");

					JFrame fr = new JFrame();

					if (jfc.showOpenDialog(fr) == JFileChooser.APPROVE_OPTION) {
						File file = jfc.getSelectedFile();
						// System.out.println(file.getPath());

						String path = file.getPath();

						Enumeration<String> en = (Enumeration<String>) listModel
								.elements();
						boolean trovato = false;
						while (en.hasMoreElements()) {
							String tmp_file = en.nextElement();
							System.out.println(path + " - " + file_old);
							if (!tmp_file.equals(file_old)
									&& path.startsWith(tmp_file))
								trovato = true;
						}

						if (!trovato)
							listModel.set(index, file.getPath());
						// jList.setModel(listModel);
					}
				}

			});
		}

		if (listModel.size() == 0)
			jButton2.setEnabled(false);
		return jButton2;
	}

	/**
	 * This method initializes jButton3
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButton3() {
		if (jButton3 == null) {
			jButton3 = new JButton();
			jButton3.setText("Remove");

			if (listModel.size() == 0)
				jButton3.setEnabled(false);

			if (jList.isSelectionEmpty())
				jButton3.setEnabled(false);

			jList.addListSelectionListener(new ListSelectionListener() {

				public void valueChanged(ListSelectionEvent e) {
					// TODO Auto-generated method stub
					if (!jList.isSelectionEmpty())
						jButton3.setEnabled(true);
					else
						jButton3.setEnabled(false);
				}

			});

			jButton3.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					// TODO Auto-generated method stub
					listModel.remove(jList.getSelectedIndex());
					// jList.setModel(listModel);

					if (listModel.size() == 0)
						jButton3.setEnabled(false);
				}

			});
		}
		return jButton3;
	}

	/**
	 * This method initializes jButton4
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButton4() {
		if (jButton4 == null) {
			jButton4 = new JButton();
			jButton4.setText("Save");

			jButton4.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					try {
						new DirectorySaver((Enumeration<String>) listModel
								.elements());
						// Aggiorna il server dei cambiamenti
						if (server != null)
							server.updateSharedFiles();						
						
					} catch (IOException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
				}

			});
		}
		return jButton4;
	}

	/**
	 * This method initializes jScrollPane
	 * 
	 * @return javax.swing.JScrollPane
	 * @throws IOException
	 */
	private JScrollPane getJScrollPane() throws IOException {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setViewportView(getJList());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jScrollPane1
	 * 
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getJScrollPane1() {
		if (jScrollPane1 == null) {
			jScrollPane1 = new JScrollPane();
			jScrollPane1.setViewportView(getJTextArea());

		}
		return jScrollPane1;
	}

	/**
	 * This method initializes jJMenuBar
	 * 
	 * @return javax.swing.JMenuBar
	 */
	private JMenuBar getJJMenuBar() {
		if (jJMenuBar == null) {
			jJMenuBar = new JMenuBar();
			jJMenuBar.add(getJMenu());
			jJMenuBar.add(getJMenu1());
		}
		return jJMenuBar;
	}

	/**
	 * This method initializes jMenu
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getJMenu() {
		if (jMenu == null) {
			jMenu = new JMenu();
			jMenu.setText("File");
			jMenu.add(getJMenuItem2());
		}
		return jMenu;
	}

	/**
	 * This method initializes jMenu1
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getJMenu1() {
		if (jMenu1 == null) {
			jMenu1 = new JMenu();
			jMenu1.setText("Help");
			jMenu1.add(getJMenuItem());
			jMenu1.add(getJMenuItem1());
		}
		return jMenu1;
	}

	/**
	 * This method initializes jMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem() {
		if (jMenuItem == null) {
			jMenuItem = new JMenuItem();
			jMenuItem.setText("License");

			jMenuItem.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					try {
						JFrame frame = new ViewTextFile("About", "LICENSE");
					} catch (IOException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
				}

			});

		}
		return jMenuItem;
	}

	/**
	 * This method initializes jMenuItem1
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem1() {
		if (jMenuItem1 == null) {
			jMenuItem1 = new JMenuItem();
			jMenuItem1.setText("About");

			jMenuItem1.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					try {
						JFrame frame = new ViewTextFile("About", "README");
					} catch (IOException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
				}

			});
		}
		return jMenuItem1;
	}

	/**
	 * This method initializes jMenuItem2
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getJMenuItem2() {
		if (jMenuItem2 == null) {
			jMenuItem2 = new JMenuItem();
			jMenuItem2.setText("Exit");

			jMenuItem2.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					if (isActive)
						getJToggleButton().doClick();
					dispose();
				}

			});
		}
		return jMenuItem2;
	}

	/**
	 * This method initializes jButton5
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButton5() {
		if (jButton5 == null) {
			jButton5 = new JButton();
			jButton5.setText("Sign");
			jButton5.setToolTipText("Sign into server php");

			jButton5.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					String pax = new String(getJPasswordField().getPassword());
					String user = getJTextField1().getText();
					if (!pax.equals("") && !user.equals("")) {
						String md5 = "";
						if (!pax.equals(PASSWORD_DEFINED)) {
							md5 = MD5.getHashString(user + pax
									+ P2PSLphpInterface.NONCE);
						} else {
							md5 = config.getMD5();
						}

						new P2PSLphpInterface(vdebug, config).setIp(md5);
					}
				}

			});
		}
		return jButton5;
	}
	
	//protected getPhpInterface()

	/**
	 * This method initializes jPasswordField
	 * 
	 * @return javax.swing.JPasswordField
	 */
	private JPasswordField getJPasswordField() {
		if (jPasswordField == null) {
			jPasswordField = new JPasswordField();
			jPasswordField.setColumns(5);
			jPasswordField.setToolTipText("Isn't request your SL password");
			jPasswordField.setHorizontalAlignment(JTextField.LEFT);

			if (!config.getMD5().equals(""))
				jPasswordField.setText(PASSWORD_DEFINED);

			jPasswordField.addFocusListener(new FocusListener() {

				public void focusGained(FocusEvent e) {
					jPasswordField.selectAll();

				}

				public void focusLost(FocusEvent e) {
					// TODO Auto-generated method stub

				}

			});
		}
		return jPasswordField;
	}

	/**
	 * This method initializes jTextField1
	 * 
	 * @return javax.swing.JTextField
	 */
	private JTextField getJTextField1() {
		if (jTextField1 == null) {
			jTextField1 = new JTextField();
			jTextField1.setColumns(5);
			jTextField1.setToolTipText("Usarname (name and surname)");

			jTextField1.setText(config.getUser());
		}
		return jTextField1;
	}

	/**
	 * This method initializes jButton6
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getJButton6() {
		if (jButton6 == null) {
			jButton6 = new JButton();
			jButton6.setText("Save");
			jButton6.setToolTipText("Save configuration");

			jButton6.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {
					String pax = new String(jPasswordField.getPassword());
					String user = jTextField1.getText();

					if (!pax.equals("") && !user.equals("")) {
						if (!pax.equals(PASSWORD_DEFINED)) {
							config
									.setMD5(
											MD5.getHashString(jTextField1
													.getText()
													+ new String(jPasswordField
															.getPassword())
													+ P2PSLphpInterface.NONCE),
											MD5
													.getHashString(jTextField1
															.getText()
															+ new String(
																	jPasswordField
																			.getPassword())
															+ P2PSLconfig.NONCE_PRIVATE_PASSWORD));
						} else {
							config.setMD5(config.getMD5(), config
									.getPrivateMD5Password());
						}
						config.setUser(jTextField1.getText());
						config.setPort(Integer.parseInt(jTextField.getText()));
						config.setServerPhp(jTextField2.getText());
						config.setAutostart(getJCheckBox().isSelected());

						jButton6.setText("Saving..");
						jButton6.setEnabled(false);
						
						config.save();
						
						jButton6.setText("Save");
						jButton6.setEnabled(true);
					}
				}

			});
		}
		return jButton6;
	}

	/**
	 * This method initializes jTextField2
	 * 
	 * @return javax.swing.JTextField
	 */
	private JTextField getJTextField2() {
		if (jTextField2 == null) {
			jTextField2 = new JTextField();
			jTextField2
					.setToolTipText("Server php for syncronization with client in SecondLife");
			jTextField2.setColumns(20);

			jTextField2.setText(config.getServerPhp());
		}
		return jTextField2;
	}

	/**
	 * This method initializes jPanel5
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanel5() {
		if (jPanel5 == null) {
			GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
			gridBagConstraints18.gridy = 4;
			gridBagConstraints18.fill = GridBagConstraints.HORIZONTAL;
			GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
			gridBagConstraints17.gridy = 4;
			GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
			gridBagConstraints15.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints15.gridy = 3;
			gridBagConstraints15.gridx = -1;
			GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
			gridBagConstraints14.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints14.gridy = 3;
			gridBagConstraints14.gridx = -1;
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints3.gridy = 2;
			gridBagConstraints3.gridx = -1;
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints4.gridy = 2;
			gridBagConstraints4.gridx = -1;
			GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
			gridBagConstraints10.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints10.gridy = 1;
			gridBagConstraints10.gridx = -1;
			GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
			gridBagConstraints9.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints9.gridy = 1;
			gridBagConstraints9.gridx = -1;
			GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
			gridBagConstraints12.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints12.gridy = 0;
			gridBagConstraints12.gridx = -1;
			GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
			gridBagConstraints11.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints11.gridy = 0;
			gridBagConstraints11.gridx = -1;
			jPanel5 = new JPanel();
			jPanel5.setLayout(new GridBagLayout());
			jPanel5.add(jLabel3, gridBagConstraints11);
			jPanel5.add(getJTextField1(), gridBagConstraints12);
			jPanel5.add(jLabel2, gridBagConstraints9);
			jPanel5.add(getJPasswordField(), gridBagConstraints10);
			jPanel5.add(jLabel, gridBagConstraints4);
			jPanel5.add(getJTextField(), gridBagConstraints3);
			jPanel5.add(jLabel4, gridBagConstraints14);
			jPanel5.add(getJTextField2(), gridBagConstraints15);
			jPanel5.add(jLabel5, gridBagConstraints17);
			jPanel5.add(getJCheckBox(), gridBagConstraints18);
		}
		return jPanel5;
	}

	/**
	 * This method initializes jCheckBox
	 * 
	 * @return javax.swing.JCheckBox
	 */
	private JCheckBox getJCheckBox() {
		if (jCheckBox == null) {
			jCheckBox = new JCheckBox();
			jCheckBox.setHorizontalAlignment(SwingConstants.LEFT);
			jCheckBox.setHorizontalTextPosition(SwingConstants.LEFT);
			jCheckBox.setToolTipText("Automatically connect on load");

			if (config.isAutostart()) {
				jCheckBox.setSelected(true);

				getJButton5().doClick();
				getJToggleButton().doClick();
			}
		}
		return jCheckBox;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				MainInterface thisClass;
				try {
					thisClass = new MainInterface();

					thisClass.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
					thisClass.setVisible(true);
				} catch (HeadlessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}
		});
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 * @throws IOException
	 */
	private void initialize() throws IOException {		
		this.config = new P2PSLconfig(this.vdebug);
		this.setSize(346, 378);
		this.setJMenuBar(getJJMenuBar());
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setContentPane(getJContentPane());
		this.setTitle("P2PSL-jserver");
		this.setVisible(true);
		
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 * @throws IOException
	 */
	private JPanel getJContentPane() throws IOException {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getJPanel(), BorderLayout.CENTER);
		}
		return jContentPane;
	}

	private void addListModel(JFileChooser jfc) {
		JFrame fr = new JFrame();

		if (jfc.showOpenDialog(fr) == JFileChooser.APPROVE_OPTION) {
			File file = jfc.getSelectedFile();
			// System.out.println(file.getPath());

			String path = file.getPath();

			Enumeration<String> en = (Enumeration<String>) listModel.elements();
			boolean trovato = false;
			while (en.hasMoreElements()) {
				if (path.startsWith(en.nextElement()))
					trovato = true;
			}

			if (!trovato)
				listModel.addElement(file.getPath());
			// jList.setModel(listModel);
		}
	}

} // @jve:decl-index=0:visual-constraint="10,10"
