//#########################################################################
//        p2pSL-jserver
//
// (C) Copyright by hachreak
//       Released under GPL v2.
//       Author : Hachreak (hachreak at gmail dot com)
//       WebSite: www.secondlifelab.it
//       Date: 01/ago/07 - 14:40:10
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
//#########################################################################

/**
 *  01/ago/07 - 14:40:10
 *  Create by hachreak
 *  Under GPL V2 license
 */

package it.secondlifelab.p2pSL.jserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

/**
 * @author hachreak
 * 
 * Class for manipulate configuration file of server.
 */
public class P2PSLconfig{

	private static String file = "config/server.xml";

	private Properties server = new Properties();

	private int DEFAULT_PORT = 8880;

	public static String NONCE_PRIVATE_PASSWORD = ":1";

	private String DEFAULT_SERVER_PHP = "http://www.secondlifelab.it/p2pSL";

	private Debug debug;

	/**
	 * @param debug debug class
	 * @throws IOException
	 * @throws FileNotFoundException
	 * @throws InvalidPropertiesFormatException
	 */
	public P2PSLconfig(Debug debug) {
		try {
			this.debug = debug;

			File f = new File(file);

			if (f.exists() == false) {
				server.clear();

				setMD5("", "");
				setUser("");
				setPort(DEFAULT_PORT);
				setServerPhp(DEFAULT_SERVER_PHP);
				setAutostart(false);
			} else {

				server.loadFromXML(new FileInputStream(f));

			}
		} catch (InvalidPropertiesFormatException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			debug.print("[ ERROR ] Invalid property format");
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			debug.print("[ ERROR ] Can't find file of configuration");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			debug.print("[ ERROR ] Can't load configuration");
		}

		debug.print("[ OK ] Configuration Loaded");
	}

	/**
	 * Get server's port
	 * 
	 * @return port
	 */
	public int getPort() {
		return new Integer(server.getProperty("port"));
	}

	/**
	 * Get user name 
	 * @return user name
	 */
	public String getUser() {
		return server.getProperty("user");
	}

	/**
	 * Get md5 
	 * @return md5
	 */
	public String getMD5() {
		return server.getProperty("md5");
	}

	/**
	 * Get private password
	 * 
	 * @return private md5 password
	 */
	public String getPrivateMD5Password() {
		return server.getProperty("md5_private_password");
	}

	/**
	 * @param md5
	 *            the mD5 to set
	 */
	public void setMD5(String md5, String md5_priv_pax) {
		server.setProperty("md5", md5);
		server.setProperty("md5_private_password", md5_priv_pax);
	}

	/**
	 * @param port
	 *            the port to set
	 */
	public void setPort(int port) {
		server.setProperty("port", new Integer(port).toString());
	}

	/**
	 * @param user
	 *            the user to set
	 */
	public void setUser(String user) {
		server.setProperty("user", user);
	}

	/**
	 * @param serverphp
	 *            the serverphp to set
	 */
	public void setServerPhp(String serverphp) {
		server.setProperty("serverphp", serverphp);
	}

	/**
	 * Save configuration
	 * 
	 * @throws IOException
	 * 
	 */
	public void save() {
		int k =1;System.out.println("uff");
		while(k==1){
			System.out.println("ok");
			
		}
		try {
			server.storeToXML(new FileOutputStream(file),
					"p2pSL-jserver configurationfile");
			debug.print("[ OK ] Configuration Saved");
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			debug.print("[ ERROR ] Can't find file of configuration");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			debug.print("[ ERROR ] Can't save configuration");
		}
		
	}

	public String getServerPhp() {
		return server.getProperty("serverphp");
	}

	/**
	 * @return the autostart
	 */
	public boolean isAutostart() {
		return (server.getProperty("autostart").equals("true") ? true : false);
	}

	/**
	 * @param autostart
	 *            the autostart to set
	 */
	public void setAutostart(boolean autostart) {
		server.setProperty("autostart", autostart ? "true" : "false");
	}

}
