package it.secondlifelab.p2pSL.jserver;

import com.prolixtech.jaminid.Request;
import com.prolixtech.jaminid.Response;

/**
 * Interface for plugin of server
 * Add a function into the server
 * 
 * Implement toString for return http response
 * 
 * @author hachreak
 *
 */
public interface Plugin extends Cloneable{

	/**
	 * @return the author
	 */
	public abstract String getAuthor();

	/**
	 * @return the authorEmail
	 */
	public abstract String getAuthorEmail();

	/**
	 * @return the authorUrl
	 */
	public abstract String getAuthorUrl();

	/**
	 * @return the copyright
	 */
	public abstract String getCopyright();

	/**
	 * @return the creationDate
	 */
	public abstract String getCreationDate();

	/**
	 * @return the description
	 */
	public abstract String getDescription();

	/**
	 * @return the license
	 */
	public abstract String getLicense();

	/**
	 * @return the name
	 */
	public abstract String getName();

	/**
	 * @return the version
	 */
	public abstract String getVersion();
	
	/**
	 * Get the virtual path for recall plugin
	 * @return virtual path for recall plugin
	 */
	public abstract String getVirtualPath();
	
	/**
	 * @param debug debug output
	 */
	public abstract void setDebug(Debug debug);
	
	/**
	 * @param config configuration of p2psl
	 */
	public abstract void setConfig(P2PSLconfig config);
	
	/**
	 * 
	 * @param request HTTP Request
	 */
	public abstract void setConnRequest(Request request);
	
	/**
	 * 
	 * @param response HTTP Response
	 */
	public abstract void setConnResponse(Response response);
	
	/**
	 * 
	 * @param dirLoader 
	 */
	public abstract void setDirectoryLoader(DirectoryLoader dirLoader);
	
	/**
	 * 
	 * @return response of the server
	 */
	public String toString();
	
	/**
	 * @return Clone the object 
	 * @throws CloneNotSupportedException 
	 */
	public Plugin clone(Request request, Response response) throws CloneNotSupportedException;
	
	/**
	 * @return true if is active
	 */
	public boolean isActive();
	
	/**
	 * Dis/Active plugin
	 * @param active true for activate 
	 */
	public void active(boolean active);
	
}