//#########################################################################
//        p2pSL-jserver
//
// (C) Copyright by hachreak
//       Released under GPL v2.
//       Author : Hachreak (hachreak at gmail dot com)
//       WebSite: www.secondlifelab.it
//       Date: 29/ott/07 - 18:51:39
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
//#########################################################################

/**
 *  29/ott/07 - 18:51:39
 *  Create by hachreak
 *  Under GPL V2 license
 */

package it.secondlifelab.p2pSL.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.prolixtech.jaminid.Request;
import com.prolixtech.jaminid.Response;

import serverPlugin.ListPlugin;

import it.secondlifelab.p2pSL.jInterface.VisualDebug;
import it.secondlifelab.p2pSL.jserver.Debug;
import it.secondlifelab.p2pSL.jserver.DirectoryLoader;
import it.secondlifelab.p2pSL.jserver.P2PSLconfig;
import it.secondlifelab.p2pSL.jserver.Plugin;
import it.secondlifelab.p2pSL.jserver.PluginFactory;
import it.secondlifelab.p2pSL.jserver.TextDebug;
import junit.framework.TestCase;

/**
 * @author hachreak
 *
 */
public class PluginFactoryTest extends TestCase {

	/**
	 * @param name
	 */
	public PluginFactoryTest(String name) {
		super(name);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * Test method for {@link it.secondlifelab.p2pSL.jserver.PluginFactory#loadClassesName(boolean)}.
	 * @throws IllegalAccessException 
	 * @throws InstantiationException 
	 * @throws ClassNotFoundException 
	 * @throws IllegalAccessException 
	 * @throws InstantiationException 
	 * @throws ClassNotFoundException 
	 */
	public void testLoadClassesName() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
		//List<Plugin> l = new ArrayList<Plugin>();
		//l.add(new ListPlugin());
		
			assertFalse("Load plugins and get ListPlugin..",PluginFactory.loadClassesName(true).contains(new ListPlugin()));
		
	}

	/**
	 * Test method for {@link it.secondlifelab.p2pSL.jserver.PluginFactory#newInstance(java.lang.String)}.
	 * @throws ClassNotFoundException 
	 * @throws IllegalAccessException 
	 * @throws InstantiationException 
	 */
	public void testNewInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
		Debug d = new TextDebug();
		Plugin p = null;
		try {
			Debug deb = new Debug(){

				public void enable(boolean enable) {
					// TODO Auto-generated method stub
					
				}

				public void isEnabled() {
					// TODO Auto-generated method stub
					
				}

				public void print(String text) {
					// TODO Auto-generated method stub
					
				}
				
			};
			PluginFactory.setConfig(new P2PSLconfig(deb));
			PluginFactory.setDebug(deb);
			try {
				PluginFactory.setDirloader(new DirectoryLoader());
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			p = PluginFactory.newInstance("/list", null, null);
		} catch (CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		//p.setDebug(d);
		assertEquals("Get new instance of ListPlugin",p.getClass().getName(),new ListPlugin().getClass().getName());
		
	}
	
	

}
