//#########################################################################
//        p2pSL-jserver
//
// (C) Copyright by hachreak
//       Released under GPL v2.
//       Author : Hachreak (hachreak at gmail dot com)
//       WebSite: www.secondlifelab.it
//       Date: 24/ott/07 - 17:20:48
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
//#########################################################################

/**
 *  24/ott/07 - 17:20:48
 *  Create by hachreak
 *  Under GPL V2 license
 */

package it.secondlifelab.p2pSL.jserver;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author hachreak
 * 
 * Factory for load and return istance of plugin
 */
public class PluginFactory {

	private static String packages = "serverPlugin";
	private static String pluginDirectoryName = "bin/serverPlugin"; //"bin/serverPlugin"
	private static File pluginDirectory = new File(pluginDirectoryName);

	private static List<Plugin> classes = null;

	/**
	 * Load a list of classes name
	 * 
	 * @param reload
	 *            if true, force reload of list
	 * @return list of classes name
	 * @throws ClassNotFoundException
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 */
	public static List<Plugin> loadClassesName(boolean reload)
			throws ClassNotFoundException, InstantiationException,
			IllegalAccessException {
		//if (PluginFactory.classes == null || reload) {
			PluginFactory.classes = new ArrayList<Plugin>();
			// raccogli solo i file non nascosti che finiscono per .class
			File[] fileList = PluginFactory.pluginDirectory
					.listFiles(new FileFilter() {
						public boolean accept(File file) {
							return file.isFile() && !file.isHidden()
									&& file.getName().endsWith(".class");
						}
					});

			// crea una lista contenente i nomi delle classi
			for (int i = 0; i < fileList.length; i++) {
				
				String name = fileList[i].getName();
				name = packages + "."
				+ name.substring(0, name.length() - ".class".length());
				Class classe = Class.forName(name);
				classes.add((Plugin) classe.newInstance());
			}
		//}
		return classes;
	}

	/**
	 * Return a instance of class
	 * 
	 * @param virtualPath
	 *            virtual path
	 * @return instance of plugin
	 * @throws InstantiationException
	 * @throws IllegalAccessException
	 * @throws ClassNotFoundException
	 */
	public static Plugin newInstance(String virtualPath)
			throws InstantiationException, IllegalAccessException,
			ClassNotFoundException {
		Iterator<Plugin> i = loadClassesName(false).iterator();
		while (i.hasNext()) {
			Plugin p = i.next();
			if (p.getVirtualPath().equals(virtualPath))
				return p.clone();
		}

		return null;
	}

}
