package br.unisinos.pcds.sgb.entity;

public class Perfil {

	public static final String TIPO_ADMINISTRADOR = "ADM";

	public static final String TIPO_ALUNO = "ALU";

	public static final String TIPO_FUNCIONARIO = "FUN";

	public static final String TIPO_OPERADOR = "OPE";

	public static final String TIPO_PROFESSOR = "PRO";

	private boolean manterUsuarios;

	private boolean manterIntemAcervo;

	private boolean autorizarRetiradasDevolucoes;

	private boolean retirarItemAcervo;

	private boolean emitirRelatorio;

	private boolean receberPagamento;
	
	private boolean renovarItensAcervo;
	
	private boolean reservarItensAcervo;

	public boolean isAutorizarRetiradasDevolucoes() {
		return autorizarRetiradasDevolucoes;
	}

	public boolean isEmitirRelatorio() {
		return emitirRelatorio;
	}

	public boolean isManterIntemAcervo() {
		return manterIntemAcervo;
	}

	public boolean isManterUsuarios() {
		return manterUsuarios;
	}

	public boolean isReceberPagamento() {
		return receberPagamento;
	}

	public boolean isRenovarItensAcervo() {
		return renovarItensAcervo;
	}

	public boolean isReservarItensAcervo() {
		return reservarItensAcervo;
	}

	public boolean isRetirarItemAcervo() {
		return retirarItemAcervo;
	}

	protected void setAutorizarRetiradasDevolucoes(
			boolean autorizarRetiradasDevolucoes) {
		this.autorizarRetiradasDevolucoes = autorizarRetiradasDevolucoes;
	}

	protected void setEmitirRelatorio(boolean emitirRelatorio) {
		this.emitirRelatorio = emitirRelatorio;
	}

	protected void setManterIntemAcervo(boolean manterIntemAcervo) {
		this.manterIntemAcervo = manterIntemAcervo;
	}

	protected void setManterUsuarios(boolean manterUsuarios) {
		this.manterUsuarios = manterUsuarios;
	}

	protected void setReceberPagamento(boolean receberPagamento) {
		this.receberPagamento = receberPagamento;
	}

	protected void setRenovarItensAcervo(boolean renovarItensAcervo) {
		this.renovarItensAcervo = renovarItensAcervo;
	}

	protected void setReservarItensAcervo(boolean reservarItensAcervo) {
		this.reservarItensAcervo = reservarItensAcervo;
	}

	protected void setRetirarItemAcervo(boolean retirarItemAcervo) {
		this.retirarItemAcervo = retirarItemAcervo;
	}

	public static Perfil getInstance(String perfil) {
		if (TIPO_ADMINISTRADOR.equals(perfil)) {
			return new Administrador();
		} else if (TIPO_ALUNO.equals(perfil)) {
			return new Aluno();
		} else if (TIPO_FUNCIONARIO.equals(perfil)) {
			return new Funcionario();
		} else if (TIPO_OPERADOR.equals(perfil)) {
			return new Operador();
		} else if (TIPO_PROFESSOR.equals(perfil)) {
			return new Professor();
		} else {
			return null;
		}
	}

}