/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.zero_separation.pds.sql;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Tim
 */
public class ClonedResultSet implements ResultSet, Serializable {

    private static final Logger logger = Logger.getLogger(ClonedResultSet.class.getName());

    int currentRow=-1;
    List<List<Object>> results;
    ClonedMetaData metaData;

    ClonedResultSet(ResultSet resultSet) throws SQLException {
        metaData = new ClonedMetaData(resultSet.getMetaData());

        results = new ArrayList();
        while (resultSet.next()) {
            List<Object> row = new ArrayList(metaData.getColumnCount());
            for (int i=1;i<=metaData.getColumnCount();i++) {
                row.add(resultSet.getObject(i));
            }
            results.add(row);
        }

        logger.log(Level.FINER, "Cloned result set {0} rows, {1} columns", new Object[]{results.size(), metaData.getColumnCount()});
    }

    public boolean next() throws SQLException {
        currentRow++;
        return currentRow<results.size();
    }

    public void close() throws SQLException {
        // Do nothing.
    }

    public String getString(int columnIndex) throws SQLException {
        Object ob = getObject(columnIndex);

        try {
            if (ob != null)
                return ob.toString();
            else
                return null;
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type ("+ob.getClass()+") ", ex);
        }
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Object ob = getObject(columnIndex);

        if (ob == null)
            return false;
        else if(ob instanceof Boolean) {
            return (Boolean)ob;
        } else if (ob instanceof Long) {
            return ((Long)ob) != 0;
        } else if (ob instanceof Integer) {
            return ((Integer)ob) != 0;
        } else if (ob instanceof BigDecimal) {
            return !((BigDecimal)ob).equals(BigDecimal.valueOf(0));
        } else
            return true;
    }

    public byte getByte(int columnIndex) throws SQLException {
        Object ob = getObject(columnIndex);

        if (ob instanceof Boolean) {
            if ((Boolean)ob)
                return 1;
            else
                return 0;
        } else if (ob instanceof Long) {
            return ((Long)ob).byteValue();
        } else if (ob instanceof Integer) {
            return ((Integer)ob).byteValue();
        } else if (ob instanceof BigDecimal) {
            return ((BigDecimal)ob).byteValue();
        } else
            return Byte.valueOf(ob.toString());
    }

    public short getShort(int columnIndex) throws SQLException {
        Object ob = getObject(columnIndex);

        if (ob instanceof Boolean) {
            if ((Boolean)ob)
                return 1;
            else
                return 0;
        } else if (ob instanceof Long) {
            return ((Long)ob).shortValue();
        } else if (ob instanceof Integer) {
            return ((Integer)ob).shortValue();
        } else if (ob instanceof BigDecimal) {
            return ((BigDecimal)ob).shortValue();
        } else
            return Short.valueOf(ob.toString());
    }

    public int getInt(int columnIndex) throws SQLException {
        Object ob = getObject(columnIndex);

        if (ob instanceof Boolean) {
            if ((Boolean)ob)
                return 1;
            else
                return 0;
        } else if (ob instanceof Long) {
            return ((Long)ob).intValue();
        } else if (ob instanceof Integer) {
            return ((Integer)ob).intValue();
        } else if (ob instanceof BigDecimal) {
            return ((BigDecimal)ob).intValue();
        } else
            return Integer.valueOf(ob.toString());
    }

    public long getLong(int columnIndex) throws SQLException {
        Object ob = getObject(columnIndex);

        if (ob instanceof Boolean) {
            if ((Boolean)ob)
                return 1;
            else
                return 0;
        } else if (ob instanceof Long) {
            return ((Long)ob).longValue();
        } else if (ob instanceof Integer) {
            return ((Integer)ob).longValue();
        } else if (ob instanceof BigDecimal) {
            return ((BigDecimal)ob).longValue();
        } else
            return Long.valueOf(ob.toString());
    }

    public float getFloat(int columnIndex) throws SQLException {
        Object ob = getObject(columnIndex);

        if (ob instanceof Boolean) {
            if ((Boolean)ob)
                return 1;
            else
                return 0;
        } else if (ob instanceof Long) {
            return ((Long)ob).floatValue();
        } else if (ob instanceof Integer) {
            return ((Integer)ob).floatValue();
        } else if (ob instanceof BigDecimal) {
            return ((BigDecimal)ob).floatValue();
        } else if (ob instanceof Float) {
            return (Float)ob;
        } else if (ob instanceof Double) {
            return ((Double)ob).floatValue();
        } else
            return Float.valueOf(ob.toString());
    }

    public double getDouble(int columnIndex) throws SQLException {
        Object ob = getObject(columnIndex);

        if (ob instanceof Boolean) {
            if ((Boolean)ob)
                return 1;
            else
                return 0;
        } else if (ob instanceof Long) {
            return ((Long)ob).doubleValue();
        } else if (ob instanceof Integer) {
            return ((Integer)ob).doubleValue();
        } else if (ob instanceof BigDecimal) {
            return ((BigDecimal)ob).doubleValue();
        } else if (ob instanceof Float) {
            return (Float)ob;
        } else if (ob instanceof Double) {
            return (Double)ob;
        } else
            return Double.valueOf(ob.toString());
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Object ob = getObject(columnIndex);

        if (ob instanceof Boolean) {
            if ((Boolean)ob)
                return BigDecimal.valueOf(1, scale);
            else
                return BigDecimal.valueOf(0, scale);
        } else if (ob instanceof Long) {
            return BigDecimal.valueOf((Long)ob, scale);
        } else if (ob instanceof Integer) {
            return BigDecimal.valueOf((Integer)ob, scale);
        } else if (ob instanceof BigDecimal) {
            return ((BigDecimal)ob).setScale(scale);
        } else if (ob instanceof Float) {
            return BigDecimal.valueOf((Float)ob).setScale(scale);
        } else if (ob instanceof Double) {
            return BigDecimal.valueOf((Double)ob).setScale(scale);
        } else
            return new BigDecimal(ob.toString()).setScale(scale);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object ob = getObject(columnIndex);

        if (ob instanceof Boolean) {
            if ((Boolean)ob)
                return BigDecimal.valueOf(1);
            else
                return BigDecimal.valueOf(0);
        } else if (ob instanceof Long) {
            return BigDecimal.valueOf((Long)ob);
        } else if (ob instanceof Integer) {
            return BigDecimal.valueOf((Integer)ob);
        } else if (ob instanceof BigDecimal) {
            return (BigDecimal)ob;
        } else if (ob instanceof Float) {
            return BigDecimal.valueOf((Float)ob);
        } else if (ob instanceof Double) {
            return BigDecimal.valueOf((Double)ob);
        } else
            return new BigDecimal(ob.toString());
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Date getDate(int columnIndex) throws SQLException {
        try {
            return (Date)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public Time getTime(int columnIndex) throws SQLException {
        try {
            return (Time)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            return (Timestamp)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return getCharacterStream(findColumn(columnLabel));
    }

    public String getString(String columnLabel) throws SQLException {
        return getString(findColumn(columnLabel));
    }

    public boolean getBoolean(String columnLabel) throws SQLException {
        return getBoolean(findColumn(columnLabel));
    }

    public byte getByte(String columnLabel) throws SQLException {
        return getByte(findColumn(columnLabel));
    }

    public short getShort(String columnLabel) throws SQLException {
        return getShort(findColumn(columnLabel));
    }

    public int getInt(String columnLabel) throws SQLException {
        return getInt(findColumn(columnLabel));
    }

    public long getLong(String columnLabel) throws SQLException {
        return getLong(findColumn(columnLabel));
    }

    public float getFloat(String columnLabel) throws SQLException {
        return getFloat(findColumn(columnLabel));
    }

    public double getDouble(String columnLabel) throws SQLException {
        return getDouble(findColumn(columnLabel));
    }

    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return getBigDecimal(findColumn(columnLabel), scale);
    }

    public byte[] getBytes(String columnLabel) throws SQLException {
        return getBytes(findColumn(columnLabel));
    }

    public Date getDate(String columnLabel) throws SQLException {
        return getDate(findColumn(columnLabel));
    }

    public Time getTime(String columnLabel) throws SQLException {
        return getTime(findColumn(columnLabel));
    }

    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return getTimestamp(findColumn(columnLabel));
    }

    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return getAsciiStream(findColumn(columnLabel));
    }

    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return getUnicodeStream(findColumn(columnLabel));
    }

    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return getBinaryStream(findColumn(columnLabel));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return metaData;
    }

    public Object getObject(int columnIndex) throws SQLException {
        return results.get(currentRow).get(columnIndex-1);
    }

    public Object getObject(String columnLabel) throws SQLException {
        return getObject(findColumn(columnLabel));
    }

    public int findColumn(String columnLabel) throws SQLException {
        return metaData.getColumnIndex(columnLabel);
    }

    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return getBigDecimal(findColumn(columnLabel));
    }

    public boolean isBeforeFirst() throws SQLException {
        return currentRow < 0;
    }

    public boolean isAfterLast() throws SQLException {
        return currentRow >= results.size();
    }

    public boolean isFirst() throws SQLException {
        return currentRow == 0;
    }

    public boolean isLast() throws SQLException {
        return currentRow == results.size()-1;
    }

    public void beforeFirst() throws SQLException {
        currentRow = -1;
    }

    public void afterLast() throws SQLException {
        currentRow = results.size();
    }

    public boolean first() throws SQLException {
        currentRow = 0;
        return results.size()>0;
    }

    public boolean last() throws SQLException {
        currentRow = results.size()-1;
        return results.size()>0;
    }

    public int getRow() throws SQLException {
        return currentRow+1;
    }

    public boolean absolute(int row) throws SQLException {
        if (row < 0)
            currentRow = results.size()+row;
        else
            currentRow = row-1;
        return currentRow > -1 && currentRow < results.size();
    }

    public boolean relative(int rows) throws SQLException {
        currentRow += rows;
        if (currentRow<-1)
            currentRow = -1;
        if (currentRow > results.size())
            currentRow = results.size();
        return currentRow > -1 && currentRow < results.size();
    }

    public boolean previous() throws SQLException {
        return relative(-1);
    }

    public int getType() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getConcurrency() throws SQLException {
        return ResultSet.CONCUR_READ_ONLY;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isClosed() throws SQLException {
        return false;
    }

    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException("Statement has been closed.");
    }

    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Ref getRef(int columnIndex) throws SQLException {
        try {
            return (Ref)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            return (Blob)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public Clob getClob(int columnIndex) throws SQLException {
        try {
            return (Clob)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public Array getArray(int columnIndex) throws SQLException {
        try {
            return (Array)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return getObject(findColumn(columnLabel), map);
    }

    public Ref getRef(String columnLabel) throws SQLException {
        return getRef(findColumn(columnLabel));
    }

    public Blob getBlob(String columnLabel) throws SQLException {
        return getBlob(findColumn(columnLabel));
    }

    public Clob getClob(String columnLabel) throws SQLException {
        return getClob(findColumn(columnLabel));
    }

    public Array getArray(String columnLabel) throws SQLException {
        return getArray(findColumn(columnLabel));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return getDate(findColumn(columnLabel), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return getTime(findColumn(columnLabel), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return getTimestamp(findColumn(columnLabel), cal);
    }

    public URL getURL(int columnIndex) throws SQLException {
        try {
            return (URL)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public URL getURL(String columnLabel) throws SQLException {
        return getURL(findColumn(columnLabel));
    }

    public RowId getRowId(int columnIndex) throws SQLException {
        try {
            return (RowId)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public RowId getRowId(String columnLabel) throws SQLException {
        return getRowId(findColumn(columnLabel));
    }

    public NClob getNClob(int columnIndex) throws SQLException {
        try {
            return (NClob)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public NClob getNClob(String columnLabel) throws SQLException {
        return getNClob(findColumn(columnLabel));
    }

    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try {
            return (SQLXML)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return getSQLXML(findColumn(columnLabel));
    }

    public String getNString(int columnIndex) throws SQLException {
        try {
            return (String)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public String getNString(String columnLabel) throws SQLException {
        return getNString(findColumn(columnLabel));
    }

    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try {
            return (Reader)getObject(columnIndex);
        } catch (ClassCastException ex) {
            throw new SQLException("Requested value not of required type "+ex);
        }
    }

    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return getNCharacterStream(findColumn(columnLabel));
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }



    public boolean wasNull() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }


    /* Warnings are not supported. */

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }


    /* Fetches are not supported. */

    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException("Cannot set fetch direction as no longer have database connection.");
    }

    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException("Cannot get fetch direction as no longer have database connection.");
    }

    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException("Cannot set fetch size as no longer have database connection.");
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException("Cannot get fetch size as no longer have database connection.");
    }

    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException("Cannot refresh row as no longer have database connection.");
    }

    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /* All modification methods are not supported. */

    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateNull(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateString(String columnLabel, String x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * A cloned copy of the essential metadata
     */
    public class ClonedMetaData implements ResultSetMetaData, Serializable {
        private List<String> columnNames;
        private List<String> columnLabels;
        private List<Integer> columnType;
        private int columnCount;

        // All insertions and retrievals should be lowercased
        private Map<String, Integer> columnIndexes = new HashMap();

        private ClonedMetaData(ResultSetMetaData metaData) throws SQLException {
            columnCount = metaData.getColumnCount();
            columnLabels = new ArrayList(columnCount);
            columnNames = new ArrayList(columnCount);
            columnType = new ArrayList(columnCount);
            for (int i=1;i<=columnCount;i++) {
                columnNames.add(metaData.getColumnName(i));
                columnType.add(metaData.getColumnType(i));
                columnLabels.add(metaData.getColumnLabel(i));
                columnIndexes.put(metaData.getColumnLabel(i).toLowerCase(), Integer.valueOf(i));
            }
        }

        int getColumnIndex(String label) {
            return columnIndexes.get(label.toLowerCase());
        }

        public int getColumnCount() throws SQLException {
            return columnCount;
        }

        public boolean isAutoIncrement(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isCaseSensitive(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isSearchable(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isCurrency(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int isNullable(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isSigned(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getColumnDisplaySize(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getColumnLabel(int column) throws SQLException {
            return columnLabels.get(column-1);
        }

        public String getColumnName(int column) throws SQLException {
            return columnNames.get(column-1);
        }

        public String getSchemaName(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getPrecision(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getScale(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getTableName(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getCatalogName(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getColumnType(int column) throws SQLException {
            return columnType.get(column-1);
        }

        public String getColumnTypeName(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isReadOnly(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isWritable(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isDefinitelyWritable(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getColumnClassName(int column) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

}
