/*
    This file is part of Picasa Album Downloader.

    Picasa Album Downloader is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Picasa Album Downloader is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Picasa Album Downloader.  If not, see <http://www.gnu.org/licenses/>.
*/

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import com.google.gdata.data.photos.AlbumEntry;
import com.google.gdata.util.ServiceException;

public class AlbumTableModel extends AbstractTableModel {
	public List<AlbumEntry> entries;

	public AlbumTableModel() {
		entries = new ArrayList<AlbumEntry>();
	}

	public void addAlbum(AlbumEntry entry) {
		entries.add(entry);
		fireTableDataChanged();
	}

	public void clear() {
		entries.clear();
		fireTableDataChanged();
	}

	public String getColumnName(int col) {
		switch (col) {
		case 0:
			return "Album name";
		case 1:
			return "Date added";
		case 2:
			return "Number of photos";
		default:
			return "Unknown";
		}
	}

	@Override
	public int getColumnCount() {
		return 3;
	}

	@Override
	public int getRowCount() {
		return entries.size();
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		if (rowIndex < 0 || rowIndex >= entries.size()) {
			return null;
		}
		Object ret = null;
		switch (columnIndex) {
		case 0:
			ret = entries.get(rowIndex).getTitle().getPlainText();
			break;
		case 1:
			DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT);
			String date = null;
			try {
				date = df.format(entries.get(rowIndex).getDate());
			} catch (ServiceException ex) {

			}
			ret = date;
			break;
		case 2:
			try {
				ret = entries.get(rowIndex).getPhotosUsed();
			} catch (ServiceException ex) {
				System.err.println(ex);
			}
			break;
		default:
			return null;
		}
		return ret;
	}
}
