package gui;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.WindowConstants;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import modelo.Equipo;
import modelo.FutbolVirtual;
import modelo.FutbolVirtualListener;
import modelo.Futbolista;
import modelo.FutbolistaCellRender;
import excepciones.Excepcion;
import excepciones.ValoresIncorrectosDeCapacidadesException;


/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class AdministracionFutbolistas extends javax.swing.JFrame implements FutbolVirtualListener {
	private JPanel jPanel3;
	private JLabel jLabel5;
	private JLabel jLabel7;
	private JButton jButton1;
	private JButton jButton2;
	private JButton jButton3;
	private JButton jButton4;
	private JPanel jPanel4;
	private JList futbolistasjList1;
	private JScrollPane jScrollPane1;
	private JTextField jTextField6;
	private JLabel jLabel6;
	private JTextField jTextField5;
	private JTextField jTextField4;
	private JLabel jLabel4;
	private JTextField jTextField3;
	private JLabel jLabel3;
	private JTextField jTextField2;
	private JLabel jLabel1;
	private JTextField jTextField1;
	private JLabel jLabel2;
	private JPanel jPanel2;
	private JPanel jPanel1;
	
	private static FutbolVirtual modeloFutbolVirtual;
	private JLabel jLabel8;
	private static Futbolista futbolistaSelected=null;

	
	public AdministracionFutbolistas() {
		this(new FutbolVirtual(new ArrayList<Futbolista>(),new ArrayList<Equipo>()) );
	}
	
	public AdministracionFutbolistas(FutbolVirtual modeloFutbolVirtual) {
		super();
		this.modeloFutbolVirtual=modeloFutbolVirtual;
		initGUI();
	}
	
	private void initGUI() {
		try {
			setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
			this.setPreferredSize(new java.awt.Dimension(640, 480));
			this.setTitle("Virtua Fulbo - Administracion de Futbolistas");
			getContentPane().setLayout(null);
			{
				jPanel3 = new JPanel();
				getContentPane().add(jPanel3, "Center");

				jPanel3.setBounds(23, 14, 589, 359);
				jPanel3.setLayout(null);
				{
					jPanel1 = new JPanel();
					jPanel3.add(jPanel1);
					jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(""),"Lista de Jugadores",TitledBorder.LEADING,TitledBorder.TOP));
					jPanel1.setBounds(17, 12, 215, 343);
					{
						jScrollPane1 = new JScrollPane();
						jPanel1.add(jScrollPane1);
						jScrollPane1.setPreferredSize(new java.awt.Dimension(193, 308));
						{
							
							
							futbolistasjList1 = new JList();
							jScrollPane1.setViewportView(futbolistasjList1);
							FlowLayout jList1Layout = new FlowLayout();
							futbolistasjList1.setLayout(null);
												
							futbolistasjList1.setListData(this.modeloFutbolVirtual.getFutbolistas().toArray());
							futbolistasjList1.setPreferredSize(new java.awt.Dimension(170, 302));
							futbolistasjList1.setCellRenderer(new FutbolistaCellRender());
							futbolistasjList1.addListSelectionListener(new ListSelectionListener() {
								public void valueChanged(ListSelectionEvent evt) {
									futbolistasjList1ValueChanged(evt);
								}
							});
						}
					}
				}
				{
					jPanel2 = new JPanel();
			
					jPanel3.add(jPanel2);
					jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(""),"Info Futbolista",TitledBorder.LEADING,TitledBorder.TOP));
					jPanel2.setLayout(null);
					jPanel2.setBounds(246, 12, 331, 343);
					

					{
						jLabel2 = new JLabel();
						jPanel2.add(jLabel2);
						jLabel2.setText("Edad");
						jLabel2.setBounds(20, 77, 83, 24);
					}
					{
						jTextField1 = new JTextField();
						jPanel2.add(jTextField1);
						jTextField1.setBounds(146, 36, 181, 20);
					}
					{
						jLabel1 = new JLabel();
						jPanel2.add(jLabel1);
						jLabel1.setText("Nombre");
						jLabel1.setBounds(20, 35, 77, 21);
					}
					{
						jTextField2 = new JTextField();
						jPanel2.add(jTextField2);
						jTextField2.setBounds(146, 79, 176, 20);
					}
					{
						jLabel3 = new JLabel();
						jPanel2.add(jLabel3);
						jLabel3.setText("Atajar");
						jLabel3.setBounds(20, 122, 34, 14);
					}
					{
						jTextField3 = new JTextField();
						jPanel2.add(jTextField3);
						jTextField3.setBounds(146, 119, 176, 20);
					}
					{
						jLabel4 = new JLabel();
						jPanel2.add(jLabel4);
						jLabel4.setText("Defender");
						jLabel4.setBounds(20, 155, 60, 14);
					}
					{
						jTextField4 = new JTextField();
						jPanel2.add(jTextField4);
						jTextField4.setBounds(146, 152, 176, 20);
					}
					{
						jLabel5 = new JLabel();
						jPanel2.add(jLabel5);
						jLabel5.setText("Atacar");
						jLabel5.setBounds(20, 186, 34, 14);
					}
					{
						jTextField5 = new JTextField();
						jPanel2.add(jTextField5);
						jTextField5.setBounds(146, 183, 176, 20);
					}
					{
						jLabel6 = new JLabel();
						jPanel2.add(jLabel6);
						jLabel6.setText("Inteligencia");
						jLabel6.setBounds(20, 216, 77, 14);
					}
					{
						jTextField6 = new JTextField();
						jPanel2.add(jTextField6);
						jTextField6.setBounds(146, 213, 176, 20);
					}
					{
						jLabel7 = new JLabel();
						jPanel2.add(jLabel7);
						jLabel7.setText("Puntos Restantes:");
						jLabel7.setBounds(21, 261, 89, 14);
					}
					{
						jLabel8 = new JLabel();
						jPanel2.add(jLabel8);
						jLabel8.setText("jLabel8");
						jLabel8.setBounds(122, 261, 195, 14);
					}
				}
			}
			{
				jPanel4 = new JPanel();
				FlowLayout jPanel4Layout = new FlowLayout();
				getContentPane().add(jPanel4);
				jPanel4.setBounds(83, 385, 432, 36);
				jPanel4.setLayout(jPanel4Layout);
				{
					jButton1 = new JButton();
					jPanel4.add(jButton1);
					jButton1.setText("Nuevo");
					jButton1.setBounds(184, 361, 75, 19);
					jButton1.addMouseListener(new MouseAdapter() {
						public void mouseEntered(MouseEvent evt) {
							jButton1MouseEntered(evt);
						}
					});
					jButton1.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
							jButton1ActionPerformed(evt);
						}
					});
				}
				{
					jButton2 = new JButton();
					jPanel4.add(jButton2);
					jButton2.setText("Modificar");
					jButton2.setBounds(296, 358, 75, 22);
					jButton2.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
							jButton2ActionPerformed(evt);
						}
					});
					jButton2.setEnabled(false);
				}
				{
					jButton3 = new JButton();
					jPanel4.add(jButton3);
					jButton3.setText("Eliminar");
					jButton3.setBounds(396, 358, 75, 23);
					jButton3.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
							jButton3ActionPerformed(evt);
						}
					});
				}
				{
					jButton4 = new JButton();
					jPanel4.add(jButton4);
					jButton4.setText("Finalizar");
					jButton4.setBounds(492, 358, 83, 23);
					jButton4.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent evt) {
							jButton4ActionPerformed(evt);
						}
					});
				}
			}
			pack();
			this.setSize(640, 480);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void futbolistasjList1ValueChanged(ListSelectionEvent evt) {
		System.out.println("futbolistasjList1.valueChanged, event="+evt);
		//TODO add your code for futbolistasjList1.valueChanged
		
		if(this.futbolistasjList1.getSelectedValue() != null){
			Futbolista f=(Futbolista) this.futbolistasjList1.getSelectedValue();
			jTextField1.setText(f.getNombre());
			jTextField1.setEnabled(false);
			jTextField2.setText(Integer.toString(f.getEdad()));
			jTextField3.setText(Integer.toString(f.getAtajar()));
			jTextField4.setText(Integer.toString(f.getDefender()));
			jTextField5.setText(Integer.toString(f.getAtacar()));
			jTextField6.setText(Integer.toString(f.getInteligencia()));
			futbolistaSelected=f;
			jButton2.setEnabled(true);
		}
		
	}

	public void listaDeEquiposModificada(FutbolVirtual futbolVirtual) {
		futbolistasjList1.setListData(this.modeloFutbolVirtual.getEquipos().toArray());
		
	}

	public void listaDeFutbolistasModificada(FutbolVirtual futbolVirtual) {
		// TODO Auto-generated method stub
		futbolistasjList1.setListData(this.modeloFutbolVirtual.getFutbolistas().toArray());
		
	}

	public static FutbolVirtual getModeloFutbolVirtual() {
		return modeloFutbolVirtual;
	}

	public void setModeloFutbolVirtual(FutbolVirtual modeloFutbolVirtual) {
		this.modeloFutbolVirtual = modeloFutbolVirtual;
	}
	
	
	
	private void jButton1ActionPerformed(ActionEvent evt) {
		System.out.println("jButton1.actionPerformed, event="+evt);
		//TODO add your code for jButton1.actionPerformed
		
		Futbolista futbolistaNuevo= new Futbolista(
			     jTextField1.getText(),Integer.parseInt(jTextField2.getText()),
			     Integer.parseInt(jTextField5.getText()),Integer.parseInt(jTextField4.getText()),
			     Integer.parseInt(jTextField3.getText()),Integer.parseInt(jTextField6.getText()));
		
		
		
		
		
		this.modeloFutbolVirtual.agregarFutbolista(futbolistaNuevo);
		
		System.out.println("FUTBOLISTA CREADO !");
		
		
			
	}
	
	private void jButton1MouseEntered(MouseEvent evt) {
		System.out.println("jButton1.mouseEntered, event="+evt);
		//TODO add your code for jButton1.mouseEntered
		int r = 0;
		try {
		String c1=jTextField3.getText();		
		String c2=jTextField4.getText();
		String c3=jTextField5.getText();
		String c4=jTextField6.getText();
		int chkEdad=Integer.parseInt(jTextField2.getText());
		int intc1=Integer.parseInt(c1);		
		int intc2=Integer.parseInt(c2);
		int intc3=Integer.parseInt(c3);
		int intc4=Integer.parseInt(c4);
		
		r=20-(intc1+intc2+intc3+intc4);
		
			
				Excepcion.valoresIncorrectosDeCapacidad(c1, c2, c3, c4);
				
				
				jLabel8.setText("20");
				jButton1.setEnabled(true);
			} catch (ValoresIncorrectosDeCapacidadesException e) {
				// TODO Auto-generated catch block
				//e.printStackTrace();
				System.out.println("EXCEPCION: ValoresIncorrectosDeCapacidadesException");
				if(r<20&&r>0)
					jLabel8.setText(Integer.toString(r));
				else
					jLabel8.setText("Negativos !");
				
				jButton1.setEnabled(false);
			} catch(NumberFormatException e){
				//e.printStackTrace();
			System.out.println("EXCEPCION: NumberFormatException");	
			jButton1.setEnabled(false);
			}

	}
	
	private void jButton2ActionPerformed(ActionEvent evt) {
		System.out.println("jButton2.actionPerformed, event="+evt);
		//TODO add your code for jButton2.actionPerformed
		try {
			Futbolista f = new Futbolista(futbolistaSelected.getNombre(),
					Integer.parseInt(jTextField2.getText()),Integer.parseInt(jTextField5.getText()),
					Integer.parseInt(jTextField4.getText()),Integer.parseInt(jTextField3.getText()),
					Integer.parseInt(jTextField6.getText()));
			f.setIdF(futbolistaSelected.getIdF());
			modeloFutbolVirtual.modificarFutbolista(f);
		} catch (NumberFormatException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private void jButton3ActionPerformed(ActionEvent evt) {
		System.out.println("jButton3.actionPerformed, event="+evt);
		//TODO add your code for jButton3.actionPerformed
		modeloFutbolVirtual.eliminarFutbolista(futbolistaSelected);
	}
	
	private void jButton4ActionPerformed(ActionEvent evt) {
		System.out.println("jButton4.actionPerformed, event="+evt);
		//TODO add your code for jButton4.actionPerformed
		jTextField1.setText("");
		jTextField2.setText("");
		jTextField3.setText("");
		jTextField4.setText("");
		jTextField5.setText("");
		jTextField6.setText("");
		this.setVisible(false);
	}

}