package modelo;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

import dao.EquipoDao;

/*import excepciones.ValoresIncorrectosDeHabilidadesException;*/

public class Equipo {
	private String nombre;
	private List<Futbolista> futbolistas= new ArrayList<Futbolista>();
	private static final int MAXJUGADORES=5;
	private int propietario;
	//private int activo;
	private int idE;
	
	private Vector<EquipoListener> listeners=new Vector<EquipoListener>();
	
	public Equipo(){
		this("",0);
	}
	public Equipo (String nombre){
	this(nombre,0);
	}
	
	
	public Equipo (String nombre, int propietario){
		this.nombre=nombre;
		this.propietario=propietario;
		//activo = 1;
		}

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	public int getPropietario() {
		return propietario;
	}

	public void setPropietario(int propietario) {
		this.propietario = propietario;
	}

	public String getNombre() {
		return nombre;
	}
	
	public void agregarFutbolista (Futbolista unFutbolista){
		boolean esta=false;
		if(futbolistas.size()<MAXJUGADORES){
			ListIterator<Futbolista> i = futbolistas.listIterator();
			while(i.hasNext())
				if(i.next().getNombre()==unFutbolista.getNombre())
					esta=true;
					
			if(!esta) {
				futbolistas.add(unFutbolista);
				this.notificarCambioListaFutbolistas();
				this.setIdE(EquipoDao.recuperarIdMax()+1);
			    EquipoDao.altaFutbolista(this.idE, unFutbolista.getIdF());
			    
			}
		}
		
	}
	
	public void eliminarFutbolista (Futbolista unFutbolista){
		ListIterator<Futbolista> i = futbolistas.listIterator();
		while(i.hasNext()){
			if(i.next().getNombre()==unFutbolista.getNombre())
			{
				i.remove();
			EquipoDao.bajaFutbolista(this.idE, unFutbolista.getIdF() );
			this.notificarCambioListaFutbolistas();
			}
		}
	}

	public List<Futbolista> getFutbolistas() {
		return futbolistas;
	}

	public void setFutbolistas(List<Futbolista> futbolistas) {
		this.futbolistas = futbolistas;
	}
	
	public int coeficienteSituacionesDeGol(){
		int devuelve=0, acumAtacar=0, acumIntel=0, segundoTermino=0;
		for(Futbolista aux: futbolistas)
		{
			acumAtacar += aux.getAtacar();
			acumIntel += aux.getInteligencia();
		}
		acumIntel+=5;
		segundoTermino = acumIntel / 10;
		devuelve = acumAtacar * segundoTermino;
		return devuelve;
	}
	
	public int coeficienteAnulacionSituacionesDeGol(){
		int devuelve=0, acumAtajar=0, acumDefender=0;
		for(Futbolista aux : futbolistas){
			acumAtajar += aux.getAtajar();
			acumDefender += aux.getDefender();
		}
		devuelve = acumAtajar + acumDefender;
		return devuelve;
	}
	
	public boolean existeFutbolista(Futbolista f){
		return this.getFutbolistas().contains(f);
	}
	
	public void agregarListener(EquipoListener listener){
		listeners.add(listener);
	}
	
	public void eliminarListener(EquipoListener listener){}
	
	public void notificarCambioListaFutbolistas(){
		for (EquipoListener listener : this.listeners) {
		listener.listaDeFutbolistasModificada(this);
		}
	}
	public int getIdE() {
		return idE;
	}
	public void setIdE(int idE) {
		this.idE = idE;
	}
	

}
