package model;

import java.sql.SQLException;
import java.util.ArrayList;

import ticketDao.ClienteDao;
import ticketDao.EspectaculoDao;


public class EmpresaDeEspectaculos {
	

	public ArrayList<Espectaculo> getEspectaculo() {
		return espectaculo;
	}

	public void setEspectaculo(ArrayList<Espectaculo> espectaculo) {
		this.espectaculo = espectaculo;
	}

	private ArrayList<Espectaculo> espectaculo;
	
	
	private static EmpresaDeEspectaculos instance = null;
	
	private EmpresaDeEspectaculos() {
	}
	
	public static EmpresaDeEspectaculos getInstance(){
		if (instance==null)
			instance = new EmpresaDeEspectaculos();
		
		return instance;
	}
	
	public void agregarEspectaculo (Espectaculo espectaculo) throws SQLException, ClassNotFoundException {
		//EsDAO.insertar
		EspectaculoDao espectaculoDao = new EspectaculoDao();
		espectaculoDao.agregarEspectaculo(espectaculo);
	}
	public void modificarEspectaculo (Espectaculo espectaculo) throws SQLException, ClassNotFoundException{
		EspectaculoDao espectaculoDao = new EspectaculoDao();
		espectaculoDao.modificarEspectaculo(espectaculo);
	}
	
	public void eliminarEspectaculo (Espectaculo espectaculo) throws SQLException, ClassNotFoundException {
		EspectaculoDao espectaculoDao = new EspectaculoDao();
		espectaculoDao.eliminarEspectaculo(espectaculo);
		//esp.setDelete(true)
		//EsDAO.update
	}
	
	public void agregarCliente (Cliente cliente) throws SQLException, ClassNotFoundException {
		ClienteDao clienteDao = new ClienteDao();
		clienteDao.agregarCliente(cliente);
		//clienteDAO.insertar
	}
	
	public void modificarCliente (Cliente cliente) throws SQLException, ClassNotFoundException {
		ClienteDao clienteDao = new ClienteDao();
		clienteDao.modificarCliente(cliente);
	}
	
	public void eliminarCliente (Cliente cliente) throws SQLException, ClassNotFoundException {
		ClienteDao clienteDao = new ClienteDao();
		clienteDao.eliminarCliente(cliente);
	}

}
