package model;
import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

import javax.swing.WindowConstants;
import javax.swing.SwingUtilities;

import ticketDao.ClienteDao;


/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class PanelCliente extends javax.swing.JFrame {
	private JPanel jPanel1;
	private JTextField tNombre;
	private JSeparator jSeparator1;
	private JButton jVolver;
	private JComboBox cCliente;
	private JLabel jLabel6;
	private JButton jBorrar;
	private JButton jModificar;
	private JButton jAgregar;
	private JButton jNuevo;
	private JTextField tTelefono;
	private JLabel jLabel4;
	private JTextField tTarjeta;
	private JLabel jLabel3;
	private JLabel jLabel2;
	private JLabel jLabel1;
	private Principal principal;
	private ClienteDao clienteDao = null;
	/**
	* Auto-generated main method to display this JFrame
	*/
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				PanelCliente inst = new PanelCliente();
				inst.setLocationRelativeTo(null);
				inst.setVisible(true);
			}
		});
	}
	
	public PanelCliente() {
		super();
		initGUI();
	}
	
	private void initGUI() {
		try {
			setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
			this.setTitle("Administracion de  Cliente");
			this.setResizable(false);
			clienteDao = new ClienteDao();
			{
				jPanel1 = new JPanel();
				getContentPane().add(jPanel1, BorderLayout.CENTER);
				//jPanel1.setLayout(jPanel1Layout);
				jPanel1.setPreferredSize(new java.awt.Dimension(519, 293));
				jPanel1.setLayout(null);
				{
					jLabel1 = new JLabel();
					jPanel1.add(jLabel1);
					jLabel1.setText("Administracion de Clientes");
					jLabel1.setBounds(170, 12, 212, 17);
					jLabel1.setFont(new java.awt.Font("Arial",3,16));
				}
				{
					jLabel2 = new JLabel();
					jPanel1.add(jLabel2);
					jLabel2.setText("Nombre");
					jLabel2.setBounds(36, 55, 37, 14);
				}
				{
					tNombre = new JTextField();
					jPanel1.add(tNombre);
					tNombre.setBounds(102, 52, 145, 21);
				}
				{
					jLabel3 = new JLabel();
					jPanel1.add(jLabel3);
					jLabel3.setText("NroTarjeta");
					jLabel3.setBounds(36, 88, 66, 15);
				}
				{
					tTarjeta = new JTextField();
					jPanel1.add(tTarjeta);
					tTarjeta.setBounds(102, 85, 145, 21);
				}
				{
					jLabel4 = new JLabel();
					jPanel1.add(jLabel4);
					jLabel4.setText("Telefono");
					jLabel4.setBounds(36, 122, 42, 14);
				}
				{
					tTelefono = new JTextField();
					jPanel1.add(tTelefono);
					tTelefono.setBounds(102, 119, 145, 21);
				}
				{
					jNuevo = new JButton();
					jPanel1.add(jNuevo);
					jNuevo.setText("Nuevo");
					jNuevo.setBounds(375, 52, 85, 21);
					jNuevo.addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent evt) {
							jNuevoMouseClicked(evt);
						}

						private void jNuevoMouseClicked(MouseEvent evt) {
							tNombre.setText("");
							tTarjeta.setText("");
							tTelefono.setText("");
							
						}
					});
				}
				{
					jAgregar = new JButton();
					jPanel1.add(jAgregar);
					jAgregar.setText("Agrega");
					jAgregar.setBounds(375, 90, 85, 21);
					jAgregar.addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent evt) {
							jAgregarMouseClicked(evt);
						}
					});
				}
				{
					jModificar = new JButton();
					jPanel1.add(jModificar);
					jModificar.setText("Modificar");
					jModificar.setBounds(375, 127, 85, 21);
					jModificar.addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent evt) {
							try {
								jModificarMouseClicked(evt);
							} catch (SQLException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							} catch (ClassNotFoundException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					});
				}
				{
					jBorrar = new JButton();
					jPanel1.add(jBorrar);
					jBorrar.setText("Borrar cliente");
					jBorrar.setBounds(375, 170, 85, 21);
					jBorrar.addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent evt) {
							try {
								jBorrarMouseClicked(evt);
							} catch (SQLException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							} catch (ClassNotFoundException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					});
				}
				{
					jLabel6 = new JLabel();
					jPanel1.add(jLabel6);
					jLabel6.setText("Clientes registrado");
					jLabel6.setBounds(68, 214, 107, 14);
				}
				{
					String[] listaClientes = generarLista (clienteDao.getCliente());
					ComboBoxModel cClienteModel = 
							new DefaultComboBoxModel(
									listaClientes);
					cCliente = new JComboBox();
					jPanel1.add(cCliente);
					cCliente.setModel(cClienteModel);
					cCliente.setBounds(203, 207, 172, 21);
					cCliente.addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent evt) {
							try {
								cClienteMouseClicked(evt);
							} catch (SQLException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							} catch (ClassNotFoundException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					});
					cCliente.addItemListener(new ItemListener() {
						public void itemStateChanged(ItemEvent evt) {
							try {
								cClienteItemStateChanged(evt);
							} catch (SQLException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							} catch (ClassNotFoundException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					});
					}
				
				{
					jVolver = new JButton();
					jPanel1.add(jVolver);
					jVolver.setText("Volver");
					jVolver.setBounds(239, 256, 65, 21);
					jVolver.addMouseListener(new MouseAdapter() {
						public void mouseClicked(MouseEvent evt) {
							jVolverMouseClicked(evt);
						}
					});
				}
				{
					jSeparator1 = new JSeparator();
					jPanel1.add(jSeparator1);
					jSeparator1.setBounds(35, 196, 425, 10);
				}
			}
			pack();
			this.setSize(529, 323);
		 }catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private String[] generarLista(ArrayList<Cliente> cliente) {
		String [] lista = new String [cliente.size()];
		int i = 0;
		for (Cliente c: cliente) {
			lista[i] = c.getNombre();
			i++;
		}
		return lista;
	}

	private void jVolverMouseClicked(MouseEvent evt) {
		principal.setVisible(true);
		this.setVisible(false);
	}

	public void setPrincipal(Principal principal) {
		this.principal = principal;
	}

	public Principal getPrincipal() {
		return principal;
	}
	
	private void jAgregarMouseClicked(MouseEvent evt) {
		Cliente cliente = new Cliente();
		cliente.setNombre(tNombre.getText());
		cliente.setNumeroTarjetaDeCredito(tTarjeta.getText());
		cliente.setTelefono(tTelefono.getText());
		try {
			EmpresaDeEspectaculos.getInstance().agregarCliente(cliente);
			String[] listaClientes = generarLista (clienteDao.getCliente());
			ComboBoxModel cClienteModel = 
				new DefaultComboBoxModel(
						listaClientes);
			cCliente.setModel(cClienteModel);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	
	}
	
	private void jModificarMouseClicked(MouseEvent evt) throws SQLException, ClassNotFoundException {
		int selected = cCliente.getSelectedIndex();
		ClienteDao cDao = new ClienteDao();
		ArrayList<Cliente> clientes =cDao.getCliente();
		Cliente cliente = clientes.get(selected);
		cliente.setNombre(tNombre.getText());
		cliente.setNumeroTarjetaDeCredito(tTarjeta.getText());
		cliente.setTelefono(tTelefono.getText());
			try {
			EmpresaDeEspectaculos.getInstance().modificarCliente(cliente);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	private void jBorrarMouseClicked(MouseEvent evt) throws SQLException, ClassNotFoundException {
		int selected = cCliente.getSelectedIndex();
		ClienteDao cDao = new ClienteDao();
		ArrayList<Cliente> clientes =cDao.getCliente();
		Cliente cliente = clientes.get(selected);
		try {
			EmpresaDeEspectaculos.getInstance().eliminarCliente(cliente);
			String[] listaClientes = generarLista (clienteDao.getCliente());
			ComboBoxModel cClienteModel = 
				new DefaultComboBoxModel(
						listaClientes);
			cCliente.setModel(cClienteModel);
			tNombre.setText("");
			tTarjeta.setText("");
			tTelefono.setText("");
		
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	private void cClienteItemStateChanged(ItemEvent evt) throws SQLException, ClassNotFoundException {
		if (cCliente.getItemCount()>0) {
		int selected = cCliente.getSelectedIndex();
		ClienteDao cDao = new ClienteDao();
		ArrayList<Cliente> clientes =cDao.getCliente();
		Cliente cliente = clientes.get(selected);
		tNombre.setText(cliente.getNombre());
		tTarjeta.setText(cliente.getNumeroTarjetaDeCredito());
		tTelefono.setText(cliente.getTelefono());
		}
		//TODO add your code for cCliente.itemStateChanged
	}
	
	private void cClienteMouseClicked(MouseEvent evt) throws SQLException, ClassNotFoundException {
		cClienteItemStateChanged(null);
	}

}
